/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.json.JSONCommandArgumentReader;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class JSONMERGE
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<? super String, ResponseWriter> biConsumer = JSONMERGE::jsonSetBiConsumer;

    public JSONMERGE() {
        super("JSON.MERGE", 4, 1, 1, 1, AclCategory.JSON.mask() | AclCategory.WRITE.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        JSONCommandArgumentReader.CommandArgs args = JSONCommandArgumentReader.readCommandArgs(arguments);
        byte[] value = arguments.get(2);
        EmbeddedJsonCache ejc = handler.getJsonCache();
        if (JSONUtil.isValueInvalid(value)) {
            handler.writer().customError("Invalid json value for JSON.MERGE");
            return handler.myStage();
        }
        CompletionStage<String> cs = ejc.merge(args.key(), args.jsonPath(), value);
        return handler.stageToReturn(cs, ctx, biConsumer);
    }

    private static void jsonSetBiConsumer(String value, ResponseWriter writer) {
        if (value == null) {
            writer.nulls();
            return;
        }
        if ("OK".equals(value)) {
            writer.ok();
            return;
        }
        writer.error(value);
    }
}

