/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.BaseResp3Command;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.server.resp.serialization.RespConstants;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufferUtils;

public abstract class RespCommand
implements BaseResp3Command {
    protected static final Log log = Log.getLog(RespCommand.class);
    private final String name;
    private final int arity;
    private final int firstKeyPos;
    private final int lastKeyPos;
    private final int steps;
    private final byte[] bytes;
    private final long aclMask;

    public boolean hasValidNumberOfArguments(List<byte[]> arguments) {
        int numberOfArgs = Math.abs(this.arity) - 1;
        return !(this.arity > 0 && arguments.size() != numberOfArgs || this.arity < 0 && arguments.size() < numberOfArgs);
    }

    public CompletionStage<RespRequestHandler> handleException(RespRequestHandler handler, Throwable t) {
        Consumer<ResponseWriter> writer = ResponseWriter.handleException(t);
        if (writer != null) {
            writer.accept(handler.writer);
            return handler.myStage();
        }
        throw CompletableFutures.asCompletionException((Throwable)t);
    }

    protected RespCommand(int arity, int firstKeyPos, int lastKeyPos, int steps, long aclMask) {
        this.name = this.getClass().getSimpleName();
        this.arity = arity;
        this.firstKeyPos = firstKeyPos;
        this.lastKeyPos = lastKeyPos;
        this.steps = steps;
        this.bytes = this.name.getBytes(StandardCharsets.US_ASCII);
        this.aclMask = aclMask;
    }

    protected RespCommand(String name, int arity, int firstKeyPos, int lastKeyPos, int steps, long aclMask) {
        this.name = name;
        this.arity = arity;
        this.firstKeyPos = firstKeyPos;
        this.lastKeyPos = lastKeyPos;
        this.steps = steps;
        this.bytes = name.getBytes(StandardCharsets.US_ASCII);
        this.aclMask = aclMask;
    }

    public String getName() {
        return this.name;
    }

    public static RespCommand fromByteBuf(ByteBuf buf, int commandLength) {
        byte ignoreCase;
        if (buf.readableBytes() < commandLength + 2) {
            return null;
        }
        int readOffset = buf.readerIndex();
        buf.readerIndex(readOffset + commandLength + 2);
        byte b = buf.getByte(readOffset);
        byte by = ignoreCase = b >= 97 ? (byte)(b - 97) : (byte)(b - 65);
        if (ignoreCase < 0 || ignoreCase > 25) {
            return null;
        }
        RespCommand[] target = Commands.ALL_COMMANDS[ignoreCase];
        if (target == null) {
            return null;
        }
        for (RespCommand possible : target) {
            if (!possible.match(buf, commandLength, readOffset)) continue;
            return possible;
        }
        return null;
    }

    public static RespCommand fromString(String s) {
        byte ignoreCase;
        char c0 = s.charAt(0);
        byte by = ignoreCase = c0 >= 'a' ? (byte)(c0 - 97) : (byte)(c0 - 65);
        if (ignoreCase < 0 || ignoreCase > 25) {
            return null;
        }
        RespCommand[] target = Commands.ALL_COMMANDS[ignoreCase];
        if (target == null) {
            return null;
        }
        for (RespCommand possible : target) {
            if (!RespUtil.isAsciiBytesEquals(possible.bytes, s)) continue;
            return possible;
        }
        return null;
    }

    public final boolean match(byte[] other) {
        return this.match(Unpooled.wrappedBuffer((byte[])other), other.length, 0);
    }

    private boolean match(ByteBuf buf, int length, int offset) {
        byte[] possibleBytes = this.bytes;
        if (length == possibleBytes.length) {
            boolean matches = true;
            for (int i = 0; i < possibleBytes.length; ++i) {
                byte upperByte = possibleBytes[i];
                byte targetByte = buf.getByte(offset + i);
                if (upperByte == targetByte || upperByte + 32 == targetByte) continue;
                matches = false;
                break;
            }
            return matches;
        }
        log.tracef("Unknown command %s", buf.getCharSequence(offset, length, StandardCharsets.US_ASCII));
        return false;
    }

    public int size(List<byte[]> arguments) {
        int base = 1 + ByteBufferUtils.stringSize(arguments.size()) + RespConstants.CRLF.length;
        int argSize = 0;
        for (byte[] argument : arguments) {
            argSize += 1 + argument.length + RespConstants.CRLF.length;
        }
        int nameSize = 1 + ByteBufferUtils.stringSize(this.name.length()) + RespConstants.CRLF.length + this.name.length() + RespConstants.CRLF.length;
        return base + nameSize + argSize;
    }

    public int getArity() {
        return this.arity;
    }

    public int getFirstKeyPos() {
        return this.firstKeyPos;
    }

    public int getLastKeyPos() {
        return this.lastKeyPos;
    }

    public int getSteps() {
        return this.steps;
    }

    @Override
    public final long aclMask() {
        return this.aclMask;
    }

    public byte[][] extractKeys(List<byte[]> arguments) {
        if (this.getFirstKeyPos() == 0) {
            return Util.EMPTY_BYTE_ARRAY_ARRAY;
        }
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        int end = this.getLastKeyPos() < 0 ? arguments.size() : this.getLastKeyPos();
        for (int i = this.getFirstKeyPos() - 1; i < end; i += this.getSteps()) {
            keys.add(arguments.get(i));
        }
        return (byte[][])keys.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY);
    }

    public String toString() {
        return this.name;
    }
}

