/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.transport.CacheInitializeInboundAdapter;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.resp.RespDecoder;
import org.infinispan.server.resp.RespHandler;
import org.infinispan.server.resp.RespServer;

public class RespChannelInitializer
implements NettyInitializer {
    private final RespServer respServer;

    public RespChannelInitializer(RespServer respServer) {
        this.respServer = respServer;
    }

    public void initializeChannel(Channel ch) {
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ch);
        metadata.protocolVersion("RESP3");
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new CacheInitializeInboundAdapter((AbstractProtocolServer)this.respServer)});
        RespDecoder decoder = new RespDecoder(this.respServer);
        pipeline.addLast(new ChannelHandler[]{decoder});
        pipeline.addLast(new ChannelHandler[]{new RespHandler(this.respServer, decoder)});
    }
}

