/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.server.resp.Intrinsics;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.logging.Log;

public abstract class BaseRespDecoder
extends ByteToMessageDecoder {
    protected static final Log log = Log.getLog(BaseRespDecoder.class);
    protected final Intrinsics.Resp2LongProcessor longProcessor = new Intrinsics.Resp2LongProcessor();
    protected final int maxContentLength;
    protected int posBefore;
    protected ChannelHandlerContext ctx;

    protected BaseRespDecoder(RespServer respServer) {
        this.maxContentLength = respServer != null ? ((RespServerConfiguration)respServer.getConfiguration()).maxContentLengthBytes() : -1;
    }

    protected <T> List<T> allocList(int size) {
        return size == 0 ? Collections.emptyList() : new ArrayList(size);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        super.handlerAdded(ctx);
    }

    public void resumeRead() {
        if (this.internalBuffer().isReadable() && this.ctx.channel().config().isAutoRead()) {
            this.ctx.channel().eventLoop().submit(() -> {
                try {
                    this.channelRead(this.ctx, Unpooled.EMPTY_BUFFER);
                    this.channelReadComplete(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            });
        }
    }
}

