/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.infinispan.AdvancedCache;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespDecoder;
import org.infinispan.server.resp.RespHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;

public class RespChannelInitializer
implements NettyInitializer {
    private final RespServer respServer;

    public RespChannelInitializer(RespServer respServer) {
        this.respServer = respServer;
    }

    public void initializeChannel(Channel ch) {
        AdvancedCache<byte[], byte[]> cache = null;
        if (this.respServer.isDefaultCacheRunning()) {
            cache = this.respServer.getCache();
        }
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ch);
        metadata.protocolVersion("RESP3");
        ChannelPipeline pipeline = ch.pipeline();
        Resp3AuthHandler initialHandler = ((RespServerConfiguration)this.respServer.getConfiguration()).authentication().enabled() ? new Resp3AuthHandler(this.respServer, cache) : this.respServer.newHandler(cache);
        RespDecoder decoder = new RespDecoder(this.respServer);
        pipeline.addLast(new ChannelHandler[]{decoder});
        pipeline.addLast(new ChannelHandler[]{new RespHandler(decoder, initialHandler)});
    }
}

