/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import java.util.List;
import org.infinispan.server.resp.json.JSONUtil;

public final class JSONCommandArgumentReader {
    public static byte[] DEFAULT_COMMAND_PATH = new byte[]{46};

    public static CommandArgs readCommandArgs(List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        return JSONCommandArgumentReader.readCommandArgs(arguments, key, 1);
    }

    public static CommandArgs readCommandArgs(List<byte[]> arguments, byte[] key, int pos) {
        byte[] path = arguments.size() > pos ? arguments.get(pos) : DEFAULT_COMMAND_PATH;
        byte[] jsonPath = JSONUtil.toJsonPath(path);
        boolean isLegacy = path != jsonPath;
        boolean isRoot = path.length == 1 && (path[0] == JSONUtil.JSON_ROOT[0] || path[0] == DEFAULT_COMMAND_PATH[0]);
        return new CommandArgs(key, path, jsonPath, isLegacy, isRoot);
    }

    record CommandArgs(byte[] key, byte[] path, byte[] jsonPath, boolean isLegacy, boolean isRoot) {
    }
}

