/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import java.util.Iterator;
import java.util.List;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.PhysicalAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.commands.FamilyCommand;
import org.infinispan.server.resp.commands.cluster.KEYSLOT;
import org.infinispan.server.resp.commands.cluster.NODES;
import org.infinispan.server.resp.commands.cluster.SHARDS;
import org.infinispan.server.resp.commands.cluster.SLOTS;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;

public class CLUSTER
extends FamilyCommand {
    private static final RespCommand[] CLUSTER_COMMANDS = new RespCommand[]{new SHARDS(), new NODES(), new SLOTS(), new KEYSLOT()};

    public CLUSTER() {
        super(-2, 0, 0, 0, AclCategory.SLOW.mask());
    }

    @Override
    public RespCommand[] getFamilyCommands() {
        return CLUSTER_COMMANDS;
    }

    public static PhysicalAddress findPhysicalAddress(EmbeddedCacheManager ecm) {
        Transport transport = (Transport)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)ecm).getComponent(Transport.class);
        if (transport == null) {
            return null;
        }
        List addresses = transport.getPhysicalAddresses();
        return addresses.isEmpty() ? null : (PhysicalAddress)addresses.get(0);
    }

    static IntSet ownedSlots(Address member, ConsistentHash ch, SegmentSlotRelation ssr) {
        IntSet slots = IntSets.mutableEmptySet();
        Iterator iterator = ch.getPrimarySegmentsForOwner(member).iterator();
        while (iterator.hasNext()) {
            int segment = (Integer)iterator.next();
            slots.addAll(ssr.segmentToSlots(segment));
        }
        return IntSets.immutableSet((IntSet)slots);
    }
}

