/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.hash;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.multimap.impl.EmbeddedMultimapPairCache;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;

public class HINCRBY
extends RespCommand
implements Resp3Command {
    public HINCRBY() {
        super(4, 1, 1, 1, AclCategory.WRITE.mask() | AclCategory.HASH.mask() | AclCategory.FAST.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedMultimapPairCache<byte[], byte[], byte[]> multimap = handler.getHashMapMultimap();
        long delta = ArgumentUtils.toLong(arguments.get(2));
        AtomicBoolean failed = new AtomicBoolean(false);
        CompletionStage cs = multimap.compute((Object)arguments.get(0), (Object)arguments.get(1), (ignore, prev) -> {
            long result;
            if (prev == null) {
                return (byte[])arguments.get(2);
            }
            long prevLong = ArgumentUtils.toLong(prev);
            if (((prevLong ^ (result = prevLong + delta)) & (delta ^ result)) < 0L) {
                failed.set(true);
                return prev;
            }
            return ArgumentUtils.toByteArray(result);
        });
        return handler.stageToReturn(cs, ctx, (res, writer) -> {
            if (failed.get()) {
                handler.writer().customError("increment or decrement would overflow");
            } else {
                writer.integers(ArgumentUtils.toLong(res));
            }
        });
    }
}

