/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Version;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespVersion;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.AuthResp3Command;
import org.infinispan.server.resp.commands.connection.AUTH;
import org.infinispan.server.resp.commands.connection.MODULE;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.SerializationHint;

public class HELLO
extends RespCommand
implements AuthResp3Command {
    public HELLO() {
        super(-1, 0, 0, 0, AclCategory.FAST.mask() | AclCategory.CONNECTION.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3AuthHandler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        CompletionStage<Boolean> successStage = null;
        try {
            handler.writer().version(RespVersion.of(ArgumentUtils.toInt(arguments.get(0))));
        }
        catch (IllegalArgumentException e) {
            handler.writer().error("-NOPROTO sorry this protocol version is not supported");
            return handler.myStage();
        }
        if (arguments.size() == 4) {
            successStage = handler.performAuth(ctx, arguments.get(2), arguments.get(3));
        } else if (!handler.isAuthorized() && handler.canUseCertAuth()) {
            successStage = handler.performAuth(ctx);
        } else if (!handler.isAuthorized()) {
            handler.writer().error("-NOAUTH HELLO must be called with the client already authenticated, otherwise the HELLO <proto> AUTH <user> <pass> option can be used to authenticate the client and select the RESP protocol version at the same time");
        } else {
            HELLO.helloResponse(handler, ctx);
        }
        if (successStage != null) {
            return handler.stageToReturn(successStage, ctx, success -> {
                RespRequestHandler next = AUTH.silentCreateAfterAuthentication(success, handler);
                if (next == null) {
                    return handler;
                }
                if (success.booleanValue()) {
                    HELLO.helloResponse(handler, ctx);
                } else {
                    handler.writer().unauthorized();
                }
                return next;
            });
        }
        return handler.myStage();
    }

    private static void helloResponse(Resp3AuthHandler handler, ChannelHandlerContext ctx) {
        String versionString = Version.getMajorMinor();
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
        ResponseWriter writer = handler.writer();
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>(7);
        response.put("server", Version.getBrandName().toLowerCase());
        response.put("version", versionString);
        response.put("proto", 3);
        response.put("id", metadata.id());
        response.put("mode", SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)handler.respServer().getCacheManager()).isClustered() ? "cluster" : "standalone");
        response.put("role", "master");
        response.put("modules", MODULE.allModulesRESP3());
        writer.map(response, new SerializationHint.KeyValueHint(Resp3Type.BULK_STRING, Resp3Type.AUTO));
    }
}

