/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.hll.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.server.resp.hll.internal.HLLRepresentation;
import org.infinispan.server.resp.hll.internal.Util;

@ThreadSafe
@ProtoTypeId(value=6103)
public class CompactSet
implements HLLRepresentation {
    static final int HLL_BUCKET_COUNT = 14;
    static final int HLL_MAX_CONSECUTIVE_ZEROES = 50;
    static final int HLL_BUCKET_TOTAL = 16384;
    static final int HLL_BUCKET_MASK = 16383;
    static final double ALPHA_INF = 0.7213475204444817;
    static final byte REGISTER_WIDTH = (byte)(64 - Long.numberOfLeadingZeros(50L));
    static final byte MAX_REGISTER_ENTRY = (byte)(1L << REGISTER_WIDTH);
    static final byte SINGLE_REGISTER_MASK = (byte)(MAX_REGISTER_ENTRY - 1);
    static final int STORE_SIZE = REGISTER_WIDTH * 16384 + SINGLE_REGISTER_MASK >>> REGISTER_WIDTH;
    @GuardedBy(value="this")
    private final long[] store;
    @GuardedBy(value="this")
    private final int[] multiplicity;
    private volatile byte minimum;

    public CompactSet() {
        this.store = new long[STORE_SIZE];
        this.multiplicity = new int[52];
        this.multiplicity[0] = 16384;
        this.minimum = 0;
    }

    @ProtoFactory
    CompactSet(Collection<Long> store, Collection<Integer> multiplicity, byte minimum) {
        this.store = store.stream().mapToLong(Long::longValue).toArray();
        this.multiplicity = multiplicity.stream().mapToInt(Integer::intValue).toArray();
        this.minimum = minimum;
    }

    void readSource(Set<Long> hashes) {
        for (long hash : hashes) {
            this.setRegister(hash);
        }
    }

    @Override
    public boolean set(byte[] data) {
        return this.setRegister(Util.hash(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long cardinality() {
        CompactSet compactSet = this;
        synchronized (compactSet) {
            double z = 16384.0 * CompactSet.tau(1.0 - (double)this.multiplicity[51] / 16384.0);
            for (int k = 51; k >= 1; --k) {
                z = 0.5 * (z + (double)this.multiplicity[k]);
            }
        }
        double v = 1.9363525058498377E8 / (z += 16384.0 * CompactSet.sigma((double)this.multiplicity[0] / 16384.0));
        return Math.round(v);
    }

    private static double sigma(double x) {
        double zPrime;
        if (x == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double y = 1.0;
        double z = x;
        while ((z += (x *= x) * (y += y)) != (zPrime = z)) {
        }
        return z;
    }

    private static double tau(double x) {
        double z;
        if (x == 0.0 || x == 1.0) {
            return 0.0;
        }
        double y = 1.0;
        double zPrime = z = 1.0 - x;
        do {
            x = Math.sqrt(x);
            zPrime = z;
            y = 0.5 * y;
        } while ((z -= Math.pow(1.0 - x, 2.0) * y) != zPrime);
        return z / 3.0;
    }

    private boolean setRegister(long hash) {
        long seq = hash >>> 14;
        byte k = (byte)(seq == 0L ? 51 : 1 + Long.numberOfTrailingZeros(seq));
        if (k > this.minimum) {
            int bucket = (int)(hash & 0x3FFFL);
            return this.setRegister(bucket, k);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRegister(int bucket, byte value) {
        assert ((long)bucket < 0x20000000L) : "Bucket is out of bound.";
        int index = bucket * REGISTER_WIDTH;
        int first = index >>> REGISTER_WIDTH;
        int second = index + REGISTER_WIDTH - 1 >>> REGISTER_WIDTH;
        int offset = index & SINGLE_REGISTER_MASK;
        boolean spilled = first != second;
        CompactSet compactSet = this;
        synchronized (compactSet) {
            byte stored = spilled ? (byte)((this.store[first] >>> offset | this.store[second] << MAX_REGISTER_ENTRY - offset) & (long)SINGLE_REGISTER_MASK) : (byte)(this.store[first] >>> offset & (long)SINGLE_REGISTER_MASK);
            if (value > stored) {
                byte by = stored;
                this.multiplicity[by] = this.multiplicity[by] - 1;
                byte by2 = value;
                this.multiplicity[by2] = this.multiplicity[by2] + 1;
                if (stored == this.minimum) {
                    while (this.multiplicity[this.minimum] == 0) {
                        this.minimum = (byte)(this.minimum + 1);
                    }
                }
                if (spilled) {
                    int n = first;
                    this.store[n] = this.store[n] & (1L << offset) - 1L;
                    int n2 = first;
                    this.store[n2] = this.store[n2] | (long)value << offset;
                    int n3 = second;
                    this.store[n3] = this.store[n3] & (long)(~(SINGLE_REGISTER_MASK >>> MAX_REGISTER_ENTRY - offset));
                    int n4 = second;
                    this.store[n4] = this.store[n4] | (long)(value >>> MAX_REGISTER_ENTRY - offset);
                } else {
                    int n = first;
                    this.store[n] = this.store[n] & ((long)SINGLE_REGISTER_MASK << offset ^ 0xFFFFFFFFFFFFFFFFL);
                    int n5 = first;
                    this.store[n5] = this.store[n5] | (long)value << offset;
                }
                return true;
            }
        }
        return false;
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    List<Long> store() {
        return LongStream.of(this.store).boxed().collect(Collectors.toList());
    }

    @ProtoField(number=2, collectionImplementation=ArrayList.class, type=Type.UINT32)
    Collection<Integer> multiplicity() {
        return IntStream.of(this.multiplicity).boxed().collect(Collectors.toList());
    }

    @ProtoField(number=3, javaType=byte.class, defaultValue="0", type=Type.UINT32)
    byte minimum() {
        return this.minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactSet that = (CompactSet)o;
        CompactSet compactSet = this;
        synchronized (compactSet) {
            CompactSet compactSet2 = that;
            synchronized (compactSet2) {
                return Arrays.equals(this.store, that.store);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        CompactSet compactSet = this;
        synchronized (compactSet) {
            return Arrays.hashCode(this.store);
        }
    }
}

