/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.tx;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.TransactionResp3Command;
import org.infinispan.server.resp.commands.tx.TransactionDecorator;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.tx.RespTransactionHandler;
import org.infinispan.server.resp.tx.TransactionCommand;
import org.infinispan.server.resp.tx.TransactionContext;

public class EXEC
extends RespCommand
implements Resp3Command,
TransactionResp3Command {
    public EXEC() {
        super(1, 0, 0, 0, AclCategory.SLOW.mask() | AclCategory.TRANSACTION.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        handler.writer().customError("EXEC without MULTI");
        return handler.myStage();
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(RespTransactionHandler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        Resp3Handler next = handler.respServer().newHandler(handler.cache());
        CompletionStage cs = handler.performingOperations(ctx).thenCompose(commands -> this.perform((List<TransactionCommand>)commands, handler, next, ctx));
        return next.stageToReturn(cs, ctx, ignore -> next);
    }

    private CompletionStage<Void> perform(List<TransactionCommand> commands, RespTransactionHandler curr, Resp3Handler next, ChannelHandlerContext ctx) {
        TransactionDecorator.TransactionResume resume;
        if (curr.hasFailed()) {
            return CompletableFuture.supplyAsync(() -> {
                curr.writer().transactionAborted();
                return null;
            }, (Executor)ctx.executor());
        }
        if (commands == null) {
            return CompletableFuture.supplyAsync(() -> {
                curr.writer().nulls();
                return null;
            }, (Executor)ctx.executor());
        }
        AdvancedCache<byte[], byte[]> cache = next.cache();
        boolean transactional = cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
        if (!transactional) {
            log.enableTransactionForMultiExec();
            resume = null;
        } else {
            resume = TransactionDecorator.beginTransaction(next, cache);
        }
        return CompletableFuture.supplyAsync(() -> {
            TransactionContext.startTransactionContext(ctx);
            curr.writer().arrayStart(commands.size());
            return CompletionStages.handleAndCompose(this.orderlyExecution(next, ctx, commands, curr.writer()), (ignore, t) -> {
                TransactionContext.endTransactionContext(ctx);
                return transactional ? TransactionDecorator.completeTransaction(resume, t == null) : CompletableFutures.completedNull();
            });
        }, (Executor)ctx.executor()).thenCompose(o -> {
            curr.writer().arrayEnd();
            return o;
        });
    }

    private CompletionStage<Void> orderlyExecution(Resp3Handler handler, ChannelHandlerContext ctx, List<TransactionCommand> commands, ResponseWriter writer) {
        return CompletionStages.performSequentially(commands.iterator(), cmd -> {
            writer.arrayNext();
            return cmd.perform(handler, ctx).thenApply(CompletableFutures.toNullFunction());
        });
    }
}

