/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.set.SINTER;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class SINTERSTORE
extends RespCommand
implements Resp3Command {
    public SINTERSTORE() {
        super(-3, 1, -1, 1, AclCategory.WRITE.mask() | AclCategory.SET.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        byte[] destination = arguments.get(0);
        List<byte[]> keys = arguments.subList(1, arguments.size());
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, keys);
        CompletionStage allEntries = esc.getAll(uniqueKeys).thenApply(sets -> SINTER.checkTypeOrEmpty(sets, uniqueKeys.size()));
        return handler.stageToReturn(((CompletableFuture)allEntries).thenCompose(sets -> handler.getEmbeddedSetCache().set((Object)destination, SINTER.intersect(sets.values(), 0))), ctx, ResponseWriter.INTEGER);
    }
}

