/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.cluster.CLUSTER;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class SHARDS
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<List<ShardInformation>, ResponseWriter> SERIALIZER = (res, writer) -> {
        writer.arrayStart(res.size());
        for (ShardInformation si : res) {
            writer.arrayNext();
            writer.write(si, si);
        }
        writer.arrayEnd();
    };
    @GuardedBy(value="this")
    private CompletionStage<List<ShardInformation>> lastExecution = null;
    @GuardedBy(value="this")
    private ConsistentHash lastAcceptedHash = null;

    public SHARDS() {
        super(2, 0, 0, 0, AclCategory.SLOW.mask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        AdvancedCache<byte[], byte[]> respCache = handler.cache();
        DistributionManager dm = respCache.getDistributionManager();
        if (dm == null) {
            handler.writer().customError("This instance has cluster support disabled");
            return handler.myStage();
        }
        LocalizedCacheTopology topology = dm.getCacheTopology();
        ConsistentHash hash = topology.getCurrentCH();
        if (hash == null) {
            handler.writer().customError("No consistent hash available");
            return handler.myStage();
        }
        SHARDS sHARDS = this;
        synchronized (sHARDS) {
            if (!hash.equals((Object)this.lastAcceptedHash)) {
                this.lastExecution = SHARDS.readShardsInformation(hash, SecurityActions.getClusterExecutor(respCache), handler.respServer().segmentSlotRelation().slotWidth());
                this.lastAcceptedHash = hash;
            }
        }
        return handler.stageToReturn(this.lastExecution, ctx, SERIALIZER);
    }

    private static CompletionStage<List<ShardInformation>> readShardsInformation(ConsistentHash hash, ClusterExecutor executor, int slotWidth) {
        HashMap<List, IntSet> segmentOwners = new HashMap<List, IntSet>();
        for (int i = 0; i < hash.getNumSegments(); ++i) {
            segmentOwners.computeIfAbsent(hash.locateOwnersForSegment(i), ignore -> IntSets.mutableEmptySet((int)hash.getNumSegments())).add(i);
        }
        return SHARDS.readNodeInformation(hash.getMembers(), executor).thenApply(information -> {
            ArrayList<ShardInformation> response = new ArrayList<ShardInformation>();
            for (Map.Entry entry : segmentOwners.entrySet()) {
                List addresses = (List)entry.getKey();
                Map<String, Object> leader = (Map<String, Object>)information.get(addresses.get(0));
                if (leader == null) {
                    log.debugf("Not found information for leader: %s", addresses.get(0));
                    String name = ((Address)addresses.get(0)).toString();
                    leader = SHARDS.createNodeSerialized(name, name, 0, "loading");
                }
                ArrayList<Map<String, Object>> replicas = null;
                if (addresses.size() > 1) {
                    replicas = new ArrayList<Map<String, Object>>();
                    for (int i = 1; i < addresses.size(); ++i) {
                        Map<String, Object> replica = (Map<String, Object>)information.get(addresses.get(i));
                        if (replica == null) {
                            String name = ((Address)addresses.get(i)).toString();
                            replica = SHARDS.createNodeSerialized(name, name, 0, "loading");
                        }
                        replicas.add(replica);
                    }
                }
                response.add(SHARDS.serialize(leader, replicas, (IntSet)entry.getValue(), slotWidth));
            }
            return response;
        });
    }

    private static CompletionStage<Map<Address, Map<String, Object>>> readNodeInformation(List<Address> members, ClusterExecutor executor) {
        ConcurrentHashMap responses = new ConcurrentHashMap(members.size());
        return executor.filterTargets(members).submitConsumer(SHARDS::readLocalNodeInformation, (address, res, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            responses.put(address, res);
        }).thenApply(ignore -> responses);
    }

    private static Map<String, Object> readLocalNodeInformation(EmbeddedCacheManager ecm) {
        CacheManagerInfo manager = ecm.getCacheManagerInfo();
        String name = manager.getNodeName();
        Address address = CLUSTER.findPhysicalAddress(ecm);
        int port = CLUSTER.findPort(address);
        String addressString = address != null ? CLUSTER.getOnlyIp(address) : ecm.getCacheManagerInfo().getNodeAddress();
        return SHARDS.createNodeSerialized(name, addressString, port, "online");
    }

    private static Map<String, Object> createNodeSerialized(String name, String address, int port, String health) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", name);
        data.put("port", port);
        data.put("ip", address);
        data.put("endpoint", address);
        data.put("replication-offset", 0);
        data.put("health", health);
        return data;
    }

    private static ShardInformation serialize(Map<String, Object> leader, List<Map<String, Object>> replicas, IntSet ranges, int slotWidth) {
        ArrayList<Integer> segments = new ArrayList<Integer>();
        int i = ranges.nextSetBit(0);
        while (i >= 0) {
            int runStart = i;
            while (ranges.contains(i + 1)) {
                ++i;
            }
            segments.add(runStart * slotWidth);
            int endSlot = (i - 1) * slotWidth;
            if (endSlot > 16384) {
                endSlot = 16383;
            }
            segments.add(endSlot);
            i = ranges.nextSetBit(i + 1);
        }
        ArrayList<NodeInformation> nodes = new ArrayList<NodeInformation>();
        if (leader != null) {
            nodes.add(NodeInformation.from(leader, "master"));
        } else {
            nodes.add(null);
        }
        if (replicas != null) {
            for (Map<String, Object> replica : replicas) {
                nodes.add(NodeInformation.from(replica, "replica"));
            }
        }
        return new ShardInformation(segments, nodes);
    }

    private record NodeInformation(String id, Integer port, String ip, String endpoint, Integer offset, String health, String role) implements JavaObjectSerializer<NodeInformation>
    {
        private static NodeInformation from(Map<String, Object> data, String role) {
            return new NodeInformation((String)data.get("id"), (Integer)data.get("port"), (String)data.get("ip"), (String)data.get("endpoint"), (Integer)data.get("replication-offset"), (String)data.get("health"), role);
        }

        @Override
        public void accept(NodeInformation ignore, ResponseWriter writer) {
            writer.writeNumericPrefix((byte)37, 7L);
            writer.string("id");
            writer.string(this.id);
            writer.string("port");
            writer.integers(this.port);
            writer.string("ip");
            writer.string(this.ip);
            writer.string("endpoint");
            writer.string(this.endpoint);
            writer.string("replication-offset");
            writer.integers(this.offset);
            writer.string("health");
            writer.string(this.health);
            writer.string("role");
            writer.string(this.role);
        }
    }

    private record ShardInformation(List<Integer> slots, List<NodeInformation> nodes) implements JavaObjectSerializer<ShardInformation>
    {
        @Override
        public void accept(ShardInformation ignore, ResponseWriter writer) {
            writer.writeNumericPrefix((byte)37, 2L);
            writer.string("slots");
            writer.array(this.slots, Resp3Type.INTEGER);
            writer.string("nodes");
            writer.arrayStart(this.nodes.size());
            for (NodeInformation node : this.nodes) {
                writer.arrayNext();
                writer.write(node, node);
            }
            writer.arrayEnd();
        }
    }
}

