/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.scripting;

import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import java.util.function.Supplier;
import org.infinispan.server.resp.scripting.LuaContext;

public class LuaContextPool {
    private final MpmcArrayQueue<LuaContext> pool;
    private final Supplier<LuaContext> supplier;

    LuaContextPool(Supplier<LuaContext> supplier, int min, int max) {
        this.supplier = supplier;
        this.pool = new MpmcArrayQueue(max);
        for (int i = 0; i < min; ++i) {
            this.pool.add((Object)this.supplier.get());
        }
    }

    LuaContext borrow() {
        LuaContext engine = (LuaContext)this.pool.poll();
        if (engine == null) {
            engine = this.supplier.get();
        }
        engine.pool = this;
        return engine;
    }

    void returnToPool(LuaContext lua) {
        if (lua == null) {
            return;
        }
        if (lua.lua.getTop() > 0) {
            throw new RuntimeException("Lua stack was not empty: " + lua.lua.getTop());
        }
        lua.pool = null;
        if (!this.pool.offer((Object)lua)) {
            lua.shutdown();
        }
    }

    public void invalidate() {
        this.pool.drain(LuaContext::shutdown);
    }

    public void shutdown() {
        this.invalidate();
    }
}

