/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.scripting.eval;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;

public class EVAL
extends RespCommand
implements Resp3Command {
    public EVAL() {
        super(-3, 0, 0, 0);
    }

    @Override
    public long aclMask() {
        return AclCategory.SCRIPTING | AclCategory.SLOW;
    }

    @Override
    public final CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        String script = RespUtil.ascii(arguments.get(0));
        int numKeys = (int)ArgumentUtils.toLong(arguments.get(1));
        if (numKeys < 0) {
            handler.writer().error("ERR Number of keys can't be negative");
            return handler.myStage();
        }
        if (numKeys > arguments.size() - 2) {
            handler.writer().error("ERR Number of keys can't be greater than number of args");
            return handler.myStage();
        }
        String[] keys = new String[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            keys[i] = RespUtil.ascii(arguments.get(i + 2));
        }
        String[] argv = new String[arguments.size() - numKeys - 2];
        for (int i = numKeys; i < arguments.size() - 2; ++i) {
            argv[i - numKeys] = RespUtil.ascii(arguments.get(i + 2));
        }
        return this.performEval(handler, ctx, script, keys, argv);
    }

    protected CompletionStage<RespRequestHandler> performEval(Resp3Handler handler, ChannelHandlerContext ctx, String script, String[] keys, String[] argv) {
        try {
            return handler.stageToReturn(handler.respServer().luaEngine().eval(handler, ctx, script, keys, argv, 0L).thenApply(__ -> handler), ctx);
        }
        catch (Exception e) {
            handler.writer().customError(e.getMessage());
            return handler.myStage();
        }
    }
}

