/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.RespPrettyPrinter;
import org.infinispan.util.function.SerializableFunction;

public class JsonGetFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, byte[]> {
    public static final AdvancedExternalizer<JsonGetFunction> EXTERNALIZER = new Externalizer();
    static final byte[] EMPTY_BYTES = new byte[0];
    public static final String ERR_PATHS_CAN_T_BE_NULL = "paths can't be null";
    byte[] space;
    byte[] newline;
    byte[] indent;
    List<byte[]> paths;
    private boolean isLegacy;

    public JsonGetFunction(List<byte[]> paths, byte[] space, byte[] newline, byte[] indent) {
        Objects.requireNonNull(paths, ERR_PATHS_CAN_T_BE_NULL);
        this.paths = paths;
        this.space = space != null ? space : EMPTY_BYTES;
        this.newline = newline != null ? newline : EMPTY_BYTES;
        this.indent = indent != null ? indent : EMPTY_BYTES;
        this.isLegacy = true;
    }

    public byte[] apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            return null;
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            RespPrettyPrinter rpp = this.space.length > 0 ? new RespPrettyPrinter(new String(this.space, StandardCharsets.UTF_8)) : new RespPrettyPrinter();
            DefaultIndenter ind = new DefaultIndenter(new String(this.indent, StandardCharsets.UTF_8), new String(this.newline, StandardCharsets.UTF_8));
            rpp.indentArraysWith((DefaultPrettyPrinter.Indenter)ind);
            rpp.indentObjectsWith((DefaultPrettyPrinter.Indenter)ind);
            JsonNode rootNode = mapper.readTree(new String(doc, StandardCharsets.UTF_8));
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            if (this.paths == null || this.paths.size() == 0) {
                byte[] resp = mapper.writer((PrettyPrinter)rpp).writeValueAsBytes((Object)rootNode);
                return resp;
            }
            List<byte[]> jsonPaths = this.paths.stream().map(p -> {
                byte[] jp = JSONUtil.toJsonPath(p);
                this.isLegacy &= jp != p;
                return jp;
            }).toList();
            if (jsonPaths.size() == 1) {
                String pathStr = new String(jsonPaths.get(0), StandardCharsets.UTF_8);
                ArrayNode nodeList = (ArrayNode)jpCtx.read(pathStr, new Predicate[0]);
                if (this.isLegacy) {
                    if (nodeList.size() == 0) {
                        throw new RuntimeException("Path '" + pathStr + "' does not exist");
                    }
                    byte[] resp = mapper.writer((PrettyPrinter)rpp).writeValueAsBytes((Object)nodeList.get(0));
                    return resp;
                }
                byte[] resp = mapper.writer((PrettyPrinter)rpp).writeValueAsBytes((Object)nodeList);
                return resp;
            }
            ObjectNode result = mapper.createObjectNode();
            for (int i = 0; i < jsonPaths.size(); ++i) {
                byte[] jsonPath = jsonPaths.get(i);
                byte[] path = this.paths.get(i);
                String jsonPathStr = new String(jsonPath, StandardCharsets.UTF_8);
                String pathStr = new String(path, StandardCharsets.UTF_8);
                ArrayNode nodeList = (ArrayNode)jpCtx.read(jsonPathStr, new Predicate[0]);
                if (this.isLegacy) {
                    if (nodeList.size() == 0) {
                        throw new RuntimeException("Path '" + jsonPathStr + "' does not exist");
                    }
                    result.set(pathStr, mapper.valueToTree((Object)nodeList.get(0)));
                    continue;
                }
                result.set(pathStr, mapper.valueToTree((Object)nodeList));
            }
            byte[] resp = mapper.writer((PrettyPrinter)rpp).writeValueAsBytes((Object)result);
            return resp;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonGetFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonGetFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.space);
            JSONUtil.writeBytes(output, object.newline);
            JSONUtil.writeBytes(output, object.indent);
            output.writeInt(object.paths.size());
            for (byte[] path : object.paths) {
                JSONUtil.writeBytes(output, path);
            }
        }

        public JsonGetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] space = JSONUtil.readBytes(input);
            byte[] newline = JSONUtil.readBytes(input);
            byte[] indent = JSONUtil.readBytes(input);
            int length = input.readInt();
            ArrayList<byte[]> paths = new ArrayList<byte[]>();
            for (int i = 0; i < length; ++i) {
                paths.add(JSONUtil.readBytes(input));
            }
            return new JsonGetFunction(paths, space, newline, indent);
        }

        public Set<Class<? extends JsonGetFunction>> getTypeClasses() {
            return Collections.singleton(JsonGetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_GET_FUNCTION;
        }
    }
}

