/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.filter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.server.resp.ExternalizerIds;

public class EventListenerKeysFilter
implements CacheEventFilter<Object, Object> {
    public static final AdvancedExternalizer<EventListenerKeysFilter> EXTERNALIZER = new Externalizer();
    private final Map<Integer, List<byte[]>> keys;

    public EventListenerKeysFilter(byte[][] keys) {
        this.keys = new HashMap<Integer, List<byte[]>>();
        for (byte[] key : keys) {
            this.keys.compute(key.length, (ignore, arr) -> {
                if (arr == null) {
                    arr = new ArrayList<byte[]>();
                }
                arr.add(key);
                return arr;
            });
        }
    }

    EventListenerKeysFilter(List<byte[]> keys) {
        this((byte[][])keys.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY));
    }

    public EventListenerKeysFilter(byte[] key) {
        this.keys = Map.of(key.length, Collections.singletonList(key));
    }

    public boolean accept(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        byte[] converted = key instanceof WrappedByteArray ? ((WrappedByteArray)key).getBytes() : (byte[])key;
        List<byte[]> candidates = this.keys.get(converted.length);
        if (candidates == null) {
            return false;
        }
        for (byte[] k : candidates) {
            if (!Arrays.equals(k, converted)) continue;
            return true;
        }
        return false;
    }

    public MediaType format() {
        return null;
    }

    private static class Externalizer
    extends AbstractExternalizer<EventListenerKeysFilter> {
        private Externalizer() {
        }

        public Set<Class<? extends EventListenerKeysFilter>> getTypeClasses() {
            return Collections.singleton(EventListenerKeysFilter.class);
        }

        public void writeObject(ObjectOutput output, EventListenerKeysFilter object) throws IOException {
            List keys = object.keys.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            MarshallUtil.marshallCollection(keys, (ObjectOutput)output);
        }

        public EventListenerKeysFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            List keys = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            return new EventListenerKeysFilter(keys);
        }

        public Integer getId() {
            return ExternalizerIds.EVENT_LISTENER_FILTER;
        }
    }
}

