/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.connection.MemoryEntrySizeUtils;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class MEMORY
extends RespCommand
implements Resp3Command {
    private static final JavaObjectSerializer<Map<String, Number>> SERIALIZER = (res, writer) -> {
        writer.writeNumericPrefix((byte)37, res.size());
        for (Map.Entry entry : res.entrySet()) {
            writer.simpleString((CharSequence)entry.getKey());
            Number v = (Number)entry.getValue();
            if (v instanceof Double) {
                writer.doubles(v);
                continue;
            }
            writer.integers(v);
        }
    };

    public MEMORY() {
        super(-2, 0, 0, 0);
    }

    @Override
    public long aclMask() {
        return AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        String subcommand;
        handler.checkPermission(AuthorizationPermission.ADMIN);
        switch (subcommand = new String(arguments.get(0), StandardCharsets.US_ASCII).toUpperCase()) {
            case "STATS": {
                handler.writer().write(MEMORY.generateMemoryStats(), SERIALIZER);
                break;
            }
            case "USAGE": {
                if (arguments.size() < 2) {
                    handler.writer().wrongArgumentCount(this);
                    return handler.myStage();
                }
                byte[] key = arguments.get(1);
                CompletableFuture cs = handler.typedCache(null).getCacheEntryAsync((Object)key);
                CompletionStage<Long> cs1 = cs.thenApply(e -> MemoryEntrySizeUtils.calculateSize(key, (InternalCacheEntry<byte[], Object>)((InternalCacheEntry)e)));
                return handler.stageToReturn(cs1, ctx, ResponseWriter.INTEGER);
            }
            case "DOCTOR": 
            case "MALLOC-STATS": 
            case "PURGE": {
                handler.writer().customError("module loading/unloading unsupported");
            }
        }
        return handler.myStage();
    }

    private static Map<String, Number> generateMemoryStats() {
        HashMap<String, Number> collector = new HashMap<String, Number>();
        collector.put("peak.allocated", 0);
        collector.put("total.allocated", 0);
        collector.put("startup.allocated", 0);
        collector.put("replication.backlog", 0);
        collector.put("clients.slaves", 0);
        collector.put("clients.normal", 0);
        collector.put("cluster.links", 0);
        collector.put("aof.buffer", 0);
        collector.put("lua.caches", 0);
        collector.put("functions.caches", 0);
        collector.put("overhead.total", 0);
        collector.put("keys.count", 0);
        collector.put("keys.bytes-per-key", 0);
        collector.put("dataset.bytes", 0);
        collector.put("dataset.percentage", 0.0);
        collector.put("peak.percentage", 0.0);
        collector.put("allocator.allocated", 0);
        collector.put("allocator.active", 0);
        collector.put("allocator.resident", 0);
        collector.put("allocator-fragmentation.ratio", 0.0);
        collector.put("allocator-fragmentation.bytes", 0);
        collector.put("allocator-rss.ratio", 0.0);
        collector.put("allocator-rss.bytes", 0);
        collector.put("rss-overhead.ratio", 0.0);
        collector.put("rss-overhead.bytes", 0);
        collector.put("fragmentation", 0.0);
        collector.put("fragmentation.bytes", 0);
        return collector;
    }
}

