/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

public class JsonMergeFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, String> {
    public static final AdvancedExternalizer<JsonMergeFunction> EXTERNALIZER = new Externalizer();
    private byte[] path;
    private byte[] value;

    public JsonMergeFunction(byte[] path, byte[] value) {
        this.path = path;
        this.value = value;
    }

    public String apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null && !JSONUtil.isRoot(this.path)) {
            throw new CacheException("new objects must be created at root");
        }
        try {
            JsonNode updateNode = JSONUtil.objectMapper.readTree(this.value);
            if (doc == null) {
                entryView.set((Object)new JsonBucket(this.value), new MetaParam.Writable[0]);
                return "OK";
            }
            ObjectNode rootObjectNode = (ObjectNode)JSONUtil.objectMapper.readTree(doc.value());
            if (JSONUtil.isRoot(this.path)) {
                return this.handleRootMerge(entryView, updateNode, rootObjectNode);
            }
            return this.handlePathMerge(entryView, updateNode, rootObjectNode);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private String handlePathMerge(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView, JsonNode updateNode, ObjectNode rootObjectNode) throws JsonProcessingException {
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
        DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootObjectNode);
        DocumentContext jpCtx = JSONUtil.parserForDefiniteSet.parse((Object)rootObjectNode);
        if (jpath.isDefinite()) {
            return this.handleDefinitePath(entryView, updateNode, rootObjectNode, jpath, jpCtx);
        }
        return this.handleWildcardPath(entryView, updateNode, rootObjectNode, jpath, jpCtxPath, jpCtx);
    }

    private String handleWildcardPath(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView, JsonNode updateNode, ObjectNode rootObjectNode, JsonPath jpath, DocumentContext jpCtxPath, DocumentContext jpCtx) throws JsonProcessingException {
        ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
        if (pathList.size() == 0) {
            throw new CacheException("Err wrong static path");
        }
        for (JsonNode pathAsNode : pathList) {
            this.merge(updateNode, JsonPath.compile((String)pathAsNode.asText(), (Predicate[])new Predicate[0]), jpCtx);
        }
        entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootObjectNode)), new MetaParam.Writable[0]);
        return "OK";
    }

    private String handleDefinitePath(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView, JsonNode updateNode, ObjectNode rootObjectNode, JsonPath jpath, DocumentContext jpCtx) {
        try {
            if (((JsonNode)jpCtx.read(jpath)).isNull()) {
                jpCtx.set(jpath, (Object)updateNode);
            } else {
                this.merge(updateNode, jpath, jpCtx);
            }
            entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootObjectNode)), new MetaParam.Writable[0]);
            return "OK";
        }
        catch (Exception e) {
            return null;
        }
    }

    private String handleRootMerge(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView, JsonNode updateNode, ObjectNode rootObjectNode) throws JsonProcessingException {
        if (updateNode.isNull()) {
            entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)updateNode)), new MetaParam.Writable[0]);
        } else {
            JsonMergeFunction.deepMerge(rootObjectNode, (ObjectNode)updateNode);
            entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootObjectNode)), new MetaParam.Writable[0]);
        }
        return "OK";
    }

    private void merge(JsonNode updateNode, JsonPath jpath, DocumentContext jpCtx) {
        JsonNode jn = (JsonNode)jpCtx.read(jpath);
        if (jn == null) {
            return;
        }
        if (jn.isObject() && updateNode.isObject()) {
            JsonMergeFunction.deepMerge((ObjectNode)jn, (ObjectNode)updateNode);
        } else {
            jpCtx.set(jpath, (Object)updateNode);
        }
    }

    private static void deepMerge(ObjectNode target, ObjectNode source) {
        source.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode sourceValue = (JsonNode)entry.getValue();
            JsonNode targetValue = target.get(fieldName);
            if (targetValue != null && targetValue.isObject() && sourceValue.isObject()) {
                JsonMergeFunction.deepMerge((ObjectNode)targetValue, (ObjectNode)sourceValue);
            } else if (sourceValue.isNull()) {
                target.remove(fieldName);
            } else {
                target.set(fieldName, sourceValue);
            }
        });
    }

    private static class Externalizer
    implements AdvancedExternalizer<JsonMergeFunction> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, JsonMergeFunction object) throws IOException {
            JSONUtil.writeBytes(output, object.path);
            JSONUtil.writeBytes(output, object.value);
        }

        public JsonMergeFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] path = JSONUtil.readBytes(input);
            byte[] value = JSONUtil.readBytes(input);
            return new JsonMergeFunction(path, value);
        }

        public Set<Class<? extends JsonMergeFunction>> getTypeClasses() {
            return Collections.singleton(JsonMergeFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.JSON_MERGE_FUNCTION;
        }
    }
}

