/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6114)
public class JsonArrinsertFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Integer>> {
    @ProtoField(value=1)
    final byte[] path;
    @ProtoField(value=2)
    final int index;
    @ProtoField(value=3)
    final List<byte[]> values;

    @ProtoFactory
    public JsonArrinsertFunction(byte[] path, int index, List<byte[]> values) {
        this.path = path;
        this.index = index;
        this.values = values;
    }

    public List<Integer> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        Optional existing = entryView.peek();
        if (existing.isEmpty()) {
            return null;
        }
        byte[] doc = ((JsonBucket)existing.get()).value();
        ObjectMapper mapper = JSONUtil.objectMapper;
        try {
            JsonNode rootNode = mapper.readTree(RespUtil.utf8(doc));
            ArrayNode srcNodes = JSONUtil.objectMapper.createArrayNode();
            for (byte[] value : this.values) {
                srcNodes.add(JSONUtil.objectMapper.readTree(value));
            }
            DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)RespUtil.utf8(this.path), (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
            ArrayList<Integer> resList = new ArrayList<Integer>();
            boolean changed = false;
            for (JsonNode pathAsNode : pathList) {
                String asText = pathAsNode.asText();
                ArrayNode node = (ArrayNode)jpCtx.read(asText, new Predicate[0]);
                if (node.get(0).isArray()) {
                    ArrayNode destNode = (ArrayNode)node.get(0);
                    int index = this.index > 0 ? this.index : destNode.size() + this.index;
                    ArrayNode newArray = this.insertAll(destNode, srcNodes, index);
                    if (JSONUtil.isRoot(asText.getBytes(StandardCharsets.UTF_8))) {
                        entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)newArray)), new MetaParam.Writable[0]);
                        resList.add(newArray.size());
                        return resList;
                    }
                    jpCtx.set(asText, (Object)newArray, new Predicate[0]);
                    changed = true;
                    resList.add(newArray.size());
                } else {
                    resList.add(null);
                }
                if (!changed) continue;
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private ArrayNode insertAll(ArrayNode outer, ArrayNode inner, int index) {
        int i;
        if (index > outer.size() || index < 0) {
            throw new CacheException("index out of bounds");
        }
        ArrayNode result = JSONUtil.objectMapper.createArrayNode();
        for (i = 0; i < index; ++i) {
            result.add(outer.get(i));
        }
        result.addAll(inner);
        for (i = index; i < outer.size(); ++i) {
            result.add(outer.get(i));
        }
        return result;
    }
}

