/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.Collection;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.logging.Header;

public class TextHeader
extends Header {
    private final String op;
    private final byte[] key;
    private final Collection<byte[]> keys;

    public TextHeader(int requestBytes, Temporal requestStart, String principalName, byte[] key, Collection<byte[]> keys, String op) {
        super(requestStart, requestBytes, principalName);
        this.key = key;
        this.keys = keys;
        this.op = op;
    }

    @Override
    public Object getKey() {
        if (this.key != null) {
            return new String(this.key, StandardCharsets.US_ASCII);
        }
        if (this.keys != null) {
            return this.keys.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY);
        }
        return null;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public String getProtocol() {
        return "MCTXT";
    }
}

