/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.TooLongFrameException;
import org.infinispan.server.core.transport.ExtendedByteBufJava;
import org.infinispan.server.memcached.binary.BinaryCommand;

public class BinaryIntrinsics {
    public static int int_(ByteBuf b) {
        if (b.readableBytes() >= 4) {
            return b.readInt();
        }
        return 0;
    }

    public static long long_(ByteBuf b) {
        if (b.readableBytes() >= 8) {
            return b.readLong();
        }
        return 0L;
    }

    public static byte byte_(ByteBuf b) {
        if (b.isReadable()) {
            return b.readByte();
        }
        return 0;
    }

    public static short short_(ByteBuf b) {
        if (b.readableBytes() >= 2) {
            return b.readShort();
        }
        return 0;
    }

    public static byte[] fixedArray(ByteBuf b, int length, int maxArrayLength) {
        if (maxArrayLength >= 0 && length > maxArrayLength) {
            throw new TooLongFrameException("Array length " + length + " exceeded " + maxArrayLength);
        }
        b.markReaderIndex();
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)b, (int)length);
    }

    public static BinaryCommand opCode(ByteBuf b) {
        if (b.isReadable()) {
            return BinaryCommand.fromOpCode(b.readByte());
        }
        return null;
    }
}

