/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.binary;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.memcached.ByteBufPool;
import org.infinispan.server.memcached.MemcachedResponse;
import org.infinispan.server.memcached.MemcachedStatus;
import org.infinispan.server.memcached.binary.BinaryDecoder;
import org.infinispan.server.memcached.binary.BinaryHeader;
import org.infinispan.server.memcached.logging.Header;

public class BinaryResponse
extends MemcachedResponse {
    public BinaryResponse(CompletionStage<?> response, Header header, GenericFutureListener<? extends Future<? super Void>> listener) {
        super(response, header, listener);
    }

    public BinaryResponse(Throwable failure, Header header) {
        super(failure, header);
    }

    @Override
    public void writeFailure(Throwable throwable, ByteBufPool allocator) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        this.useErrorMessage(cause.getMessage());
        if (cause instanceof SecurityException) {
            BinaryDecoder.response(allocator, (BinaryHeader)this.header, MemcachedStatus.AUTHN_ERROR, Util.EMPTY_BYTE_ARRAY, throwable.getMessage().getBytes(StandardCharsets.US_ASCII));
        }
    }
}

