/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

public class ParseUtil {
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    public static final byte[] ZERO = new byte[]{48};

    private ParseUtil() {
    }

    public static long readLong(byte[] in) {
        byte b;
        if (in == null || in.length == 0) {
            throw new NumberFormatException("Empty argument");
        }
        boolean negative = false;
        int i = 0;
        if (in[0] < 48) {
            if (in[0] != 45 && in[0] != 43 || in.length == 1) {
                throw new NumberFormatException("Invalid character: " + in[0]);
            }
            negative = true;
            i = 1;
        }
        if ((b = in[i++]) < 48 || b > 57) {
            throw new NumberFormatException("Invalid character: " + b);
        }
        long result = b - 48;
        while (i < in.length) {
            b = in[i];
            if (b < 48 || b > 57) {
                throw new NumberFormatException("Invalid character: " + b);
            }
            result = (result << 3) + (result << 1) + (long)(b - 48);
            ++i;
        }
        return negative ? -result : result;
    }

    public static int readInt(byte[] in) {
        long v = ParseUtil.readLong(in);
        if (v > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
            throw new NumberFormatException("Invalid integer: " + v);
        }
        return (int)v;
    }

    public static byte[] writeAsciiLong(long in) {
        int r;
        long q;
        int numberDigits;
        if (in == 0L) {
            return ZERO;
        }
        int writerIndex = numberDigits = ParseUtil.stringSize(in);
        boolean negative = in < 0L;
        byte[] out = new byte[numberDigits];
        if (!negative) {
            in = -in;
        }
        while (in <= -100L) {
            q = in / 100L;
            r = (int)(q * 100L - in);
            in = q;
            out[--writerIndex] = DigitOnes[r];
            out[--writerIndex] = DigitTens[r];
        }
        q = in / 10L;
        r = (int)(q * 10L - in);
        out[--writerIndex] = (byte)(48 + r);
        if (q < 0L) {
            out[--writerIndex] = (byte)(48L - q);
        }
        if (negative) {
            out[0] = 45;
        }
        return out;
    }

    private static int stringSize(long x) {
        int d = 1;
        if (x >= 0L) {
            d = 0;
            x = -x;
        }
        int p = -10;
        for (int i = 1; i < 10; ++i) {
            if (x > (long)p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }
}

