/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.text;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.util.List;
import org.infinispan.commons.util.Util;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.text.TextAuthDecoder;
import org.infinispan.server.memcached.text.TextCommand;
import org.infinispan.server.memcached.text.TextIntrinsics;

public class TextAuthDecoderImpl
extends TextAuthDecoder {
    private int state;
    private int requestBytes;
    private long mc_long_number;
    private int mc_readBuf;
    private int mc_parseUnsignedInt;
    private long mc_exptime;
    private byte[] mc_text_key;
    private long mc_parseLong;
    private int mc_flags;
    private boolean mc_consumeLine;
    private ByteBuf mc_token;
    private byte[] mc_fixedArray;
    private TextCommand mc_command_name;
    private int mc_int_number;
    private byte[] mc_text;
    private TextCommand mc_command;
    private int mc_vsize;
    private List<byte[]> mc_text_key_list;
    private byte[] mc_key;
    private byte[] mc_value;
    private short mc_eol;
    private short mc_short;
    private List<byte[]> mc_text_list;
    private List<byte[]> mc_readByteList;
    private boolean mc_eowc;
    private boolean deadEnd = false;

    public TextAuthDecoderImpl(MemcachedServer server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(ctx, t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.posBefore = buf.readerIndex();
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.mc_command = TextIntrinsics.command(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_command_name = this.mc_command;
                this.state = 3;
            }
            case 3: {
                this.requestStart = Instant.now();
                this.state = 4;
            }
            case 4: {
                switch (this.mc_command_name) {
                    case set: {
                        this.state = 5;
                        return true;
                    }
                }
                throw new IllegalArgumentException("Unknown command " + String.valueOf((Object)this.mc_command_name));
            }
            case 5: {
                int pos = buf.readerIndex();
                this.mc_text_key = TextIntrinsics.text_key(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_key = this.mc_text_key;
                this.state = 6;
            }
            case 6: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_flags = this.mc_int_number;
                this.state = 7;
            }
            case 7: {
                int pos = buf.readerIndex();
                this.mc_long_number = TextIntrinsics.long_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_exptime = this.mc_long_number;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.mc_int_number = TextIntrinsics.int_number(buf, this.reader, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_vsize = this.mc_int_number;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 10;
            }
            case 10: {
                if (this.mc_vsize > 0) {
                    this.state = 12;
                    return true;
                }
                this.mc_value = Util.EMPTY_BYTE_ARRAY;
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.mc_short = TextIntrinsics.short_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_eol = this.mc_short;
                this.state = 13;
                return true;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.mc_fixedArray = TextIntrinsics.fixedArray(buf, this.mc_vsize, this.bytesAvailable(buf, this.requestBytes));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.mc_value = this.mc_fixedArray;
                this.state = 11;
                return true;
            }
            case 13: {
                this.auth(this.mc_value);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            log.tracef("Invalid state of parsing", new Object[0]);
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
        this.state = 0;
        if (t instanceof TooLongFrameException) {
            TooLongFrameException tlfe = (TooLongFrameException)t;
            log.requestTooLarge(ctx.channel(), tlfe);
            ctx.close();
            return;
        }
        log.trace((Object)"Parsing error", t);
    }

    private void reset() {
        this.requestBytes = 0;
        this.mc_long_number = 0L;
        this.mc_readBuf = 0;
        this.mc_parseUnsignedInt = 0;
        this.mc_exptime = 0L;
        this.mc_text_key = null;
        this.mc_parseLong = 0L;
        this.mc_flags = 0;
        this.mc_consumeLine = false;
        this.mc_token = null;
        this.mc_fixedArray = null;
        this.mc_command_name = null;
        this.mc_int_number = 0;
        this.mc_text = null;
        this.mc_command = null;
        this.mc_vsize = 0;
        this.mc_text_key_list = null;
        this.mc_key = null;
        this.mc_value = null;
        this.mc_eol = 0;
        this.mc_short = 0;
        this.mc_text_list = null;
        this.mc_readByteList = null;
        this.mc_eowc = false;
    }

    public int requestBytes() {
        return this.requestBytes;
    }
}

