/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.insights.scheduler;

import com.redhat.insights.InsightsErrorCode;
import com.redhat.insights.InsightsException;
import com.redhat.insights.InsightsScheduler;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.logging.InsightsLogger;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.server.insights.logging.Log;
import org.infinispan.util.concurrent.BlockingManager;

public class InfinispanInsightsScheduler
implements InsightsScheduler {
    private static final Log log = Log.getLog(InfinispanInsightsScheduler.class);
    private final InsightsLogger logger;
    private final InsightsConfiguration configuration;
    private final BlockingManager blockingManager;
    private volatile boolean active = true;

    public InfinispanInsightsScheduler(InsightsLogger logger2, InsightsConfiguration configuration, BlockingManager blockingManager) {
        this.logger = logger2;
        this.configuration = configuration;
        this.blockingManager = blockingManager;
    }

    public ScheduledFuture<?> scheduleConnect(Runnable sendConnect) {
        return this.scheduleAtFixedRate(sendConnect, 0L, this.configuration.getConnectPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public ScheduledFuture<?> scheduleJarUpdate(Runnable sendNewJarsIfAny) {
        return this.scheduleAtFixedRate(sendNewJarsIfAny, this.configuration.getUpdatePeriod().getSeconds(), this.configuration.getUpdatePeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public boolean isShutdown() {
        return false;
    }

    public void shutdown() {
        this.active = false;
    }

    public List<Runnable> shutdownNow() {
        return List.of();
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (!this.active) {
            log.clientSchedulerShutDown();
        }
        Runnable wrapped = () -> {
            try {
                command.run();
            }
            catch (InsightsException ix) {
                this.logger.error(InsightsErrorCode.ERROR_SCHEDULED_SENT.formatMessage("Red Hat Insights client scheduler shutdown, scheduled send failed: " + ix.getMessage()), (Throwable)ix);
                this.shutdown();
                throw ix;
            }
            catch (Exception x) {
                this.logger.error(InsightsErrorCode.ERROR_SCHEDULED_SENT.formatMessage("Red Hat Insights client scheduler shutdown, non-Insights failure: " + x.getMessage()), (Throwable)x);
                this.shutdown();
                throw x;
            }
        };
        return this.blockingManager.scheduleRunBlockingAtFixedRate(wrapped, initialDelay, period, unit, (Object)this);
    }
}

