/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.insights;

import com.redhat.insights.Filtering;
import com.redhat.insights.InsightsReportController;
import com.redhat.insights.InsightsScheduler;
import com.redhat.insights.config.InsightsConfiguration;
import com.redhat.insights.core.httpclient.InsightsJdkHttpClient;
import com.redhat.insights.http.InsightsFileWritingClient;
import com.redhat.insights.http.InsightsHttpClient;
import com.redhat.insights.http.InsightsMultiClient;
import com.redhat.insights.jars.ClasspathJarInfoSubreport;
import com.redhat.insights.logging.InsightsLogger;
import com.redhat.insights.reports.InsightsReport;
import com.redhat.insights.reports.InsightsSubreport;
import com.redhat.insights.tls.PEMSupport;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Version;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.insights.InfinispanInsightsConfiguration;
import org.infinispan.server.insights.logging.InsightsLoggerDelegate;
import org.infinispan.server.insights.logging.Log;
import org.infinispan.server.insights.report.InfinispanSubreport;
import org.infinispan.server.insights.report.InfinispanTopReport;
import org.infinispan.server.insights.scheduler.InfinispanInsightsScheduler;
import org.infinispan.util.concurrent.BlockingManager;

public class InsightsService {
    private static final Log log = Log.getLog(InsightsService.class);
    private final ServerManagement server;
    private final InsightsConfiguration config;
    private final InsightsLogger insightsLogger;
    private final InsightsReport insightsReport;
    private InsightsReportController insightsReportController;
    private volatile String identificationName;

    public InsightsService(ServerManagement server) {
        this.server = server;
        this.config = new InfinispanInsightsConfiguration(this::identificationName);
        this.insightsLogger = new InsightsLoggerDelegate(log);
        LinkedHashMap<String, InsightsSubreport> subReports = new LinkedHashMap<String, InsightsSubreport>(2);
        InfinispanSubreport infinispanSubreport = new InfinispanSubreport(this::overviewReport);
        ClasspathJarInfoSubreport jarsSubreport = new ClasspathJarInfoSubreport(this.insightsLogger);
        subReports.put("infinispan", infinispanSubreport);
        subReports.put("jars", (InsightsSubreport)jarsSubreport);
        this.insightsReport = new InfinispanTopReport(this.insightsLogger, this.config, this::identificationName, subReports);
    }

    public void start(BlockingManager blockingManager) {
        PEMSupport pemSupport = new PEMSupport(this.insightsLogger, this.config);
        Supplier<SSLContext> sslContextSupplier = () -> {
            try {
                return pemSupport.createTLSContext();
            }
            catch (Throwable ex) {
                log.insightsCertificateError();
                throw ex;
            }
        };
        InfinispanInsightsScheduler insightsScheduler = new InfinispanInsightsScheduler(this.insightsLogger, this.config, blockingManager);
        try {
            this.insightsReportController = InsightsReportController.of((InsightsLogger)this.insightsLogger, (InsightsConfiguration)this.config, (InsightsReport)this.insightsReport, () -> new InsightsMultiClient(this.insightsLogger, new InsightsHttpClient[]{new InsightsJdkHttpClient(this.insightsLogger, this.config, sslContextSupplier), new InsightsFileWritingClient(this.insightsLogger, this.config)}), (InsightsScheduler)insightsScheduler, new LinkedBlockingQueue());
            this.insightsReportController.generate();
        }
        catch (Throwable ex) {
            log.insightsServiceSetupError(ex);
        }
    }

    public void stop() {
        if (this.insightsReportController != null) {
            this.insightsReportController.shutdown();
        }
    }

    public InsightsReport report() {
        this.insightsReport.generateReport(Filtering.DEFAULT);
        return this.insightsReport;
    }

    public String identificationName() {
        if (this.identificationName == null) {
            this.overviewReport();
        }
        return this.identificationName;
    }

    public boolean isOptingOut() {
        return this.config.isOptingOut();
    }

    private Json overviewReport() {
        Json nodeIdReport;
        Json report = this.server.overviewReport();
        if (this.identificationName != null) {
            return report;
        }
        if (log.isDebugEnabled()) {
            log.debug("Starting Insights integration. Current Infinispan report: \n\r" + report.toPrettyString());
        }
        String nodeId = (nodeIdReport = report.at("node-id")).isNull() ? UUID.randomUUID().toString() : nodeIdReport.asString();
        this.identificationName = Version.getBrandName() + " " + nodeId;
        return report;
    }
}

