/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.insights;

import java.lang.invoke.MethodHandles;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.insights.InsightsService;
import org.infinispan.server.insights.config.InsightsActivation;
import org.infinispan.server.insights.logging.Log;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;

@InfinispanModule(name="insights", requiredModules={"core", "server-runtime"})
public class InsightsModule
implements ModuleLifecycle {
    public static final String REDHAT_INSIGHTS_ACTIVATION_PROPERTY_NAME = "infinispan.insights.activation";
    public static final String REPORT_VERSION = "1.0.0";
    private static final String REDHAT_INSIGHTS_ACTIVATION_VARIABLE_NAME = "INFINISPAN_INSIGHTS_ACTIVATION";
    public static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)"org.infinispan.SERVER");
    private InsightsService service;

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        InsightsActivation activation = InsightsModule.activation();
        if (InsightsActivation.DISABLED.equals((Object)activation)) {
            log.insightsDisabled();
            return;
        }
        ServerManagement server = (ServerManagement)gcr.getComponent(ServerManagement.class);
        if (server == null) {
            log.serverManagementLookupFailed();
            return;
        }
        this.service = new InsightsService(server);
        gcr.registerComponent((Object)this.service, InsightsService.class);
        if (InsightsActivation.LOCAL.equals((Object)activation)) {
            log.insightsLocallyEnabled();
            return;
        }
        if (this.service.isOptingOut()) {
            String envOptOut = "RHT_INSIGHTS_JAVA_OPT_OUT";
            String sysOptOut = envOptOut.toLowerCase().replace('_', '.');
            log.optOutTrue(envOptOut, sysOptOut);
            return;
        }
        log.insightsEnabled();
        BlockingManager blockingManager = (BlockingManager)gcr.getComponent(BlockingManager.class);
        this.service.start(blockingManager);
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        if (this.service != null) {
            this.service.stop();
        }
    }

    private static InsightsActivation activation() {
        String activation = System.getProperty(REDHAT_INSIGHTS_ACTIVATION_PROPERTY_NAME);
        if (activation == null) {
            activation = System.getenv(REDHAT_INSIGHTS_ACTIVATION_VARIABLE_NAME);
        }
        if (activation == null || activation.equalsIgnoreCase(InsightsActivation.ENABLED.name())) {
            return InsightsActivation.ENABLED;
        }
        if (activation.equalsIgnoreCase(InsightsActivation.LOCAL.name())) {
            return InsightsActivation.LOCAL;
        }
        if (activation.equalsIgnoreCase(InsightsActivation.DISABLED.name())) {
            return InsightsActivation.DISABLED;
        }
        log.insightsActivationNotValidValue(REDHAT_INSIGHTS_ACTIVATION_PROPERTY_NAME, activation);
        return InsightsActivation.ENABLED;
    }
}

