package org.infinispan.server.insights.logging;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void insightsActivationNotValidValue(final String propertyName, final String invalidValue) {
        super.log.logf(FQCN, WARN, null, insightsActivationNotValidValue$str(), propertyName, invalidValue);
    }
    protected String insightsActivationNotValidValue$str() {
        return "ISPN032001: Invalid value for `%s` property: `%s`. Using the default: 'local'.";
    }
    @Override
    public final void insightsDisabled() {
        super.log.logf(FQCN, INFO, null, insightsDisabled$str());
    }
    protected String insightsDisabled$str() {
        return "ISPN032002: Red Hat Insights integration is fully disabled";
    }
    @Override
    public final void serverManagementLookupFailed() {
        super.log.logf(FQCN, WARN, null, serverManagementLookupFailed$str());
    }
    protected String serverManagementLookupFailed$str() {
        return "ISPN032003: Infinispan failed to lookup the server management component. Thus Red Hat Insights integration will be fully disabled.";
    }
    @Override
    public final void insightsLocallyEnabled() {
        super.log.logf(FQCN, INFO, null, insightsLocallyEnabled$str());
    }
    protected String insightsLocallyEnabled$str() {
        return "ISPN032004: Local Insights reporting";
    }
    @Override
    public final void insightsEnabled() {
        super.log.logf(FQCN, INFO, null, insightsEnabled$str());
    }
    protected String insightsEnabled$str() {
        return "ISPN032005: Remote Insights reporting";
    }
    @Override
    public final void optOutTrue(final String environmentVariable, final String systemProperty) {
        super.log.logf(FQCN, INFO, null, optOutTrue$str(), environmentVariable, systemProperty);
    }
    protected String optOutTrue$str() {
        return "ISPN032006: The environment variable '%s' or the system property '%s' is set to true. The Insights reports will be disabled.";
    }
    @Override
    public final void insightsCertificateError() {
        super.log.logf(FQCN, INFO, null, insightsCertificateError$str());
    }
    protected String insightsCertificateError$str() {
        return "ISPN032007: Error getting certificate to connect to Red Hat Insight";
    }
    @Override
    public final void insightsServiceSetupError(final Throwable t) {
        super.log.logf(FQCN, INFO, t, insightsServiceSetupError$str());
    }
    protected String insightsServiceSetupError$str() {
        return "ISPN032008: Error setting up Red Hat Insight report service";
    }
    @Override
    public final void clientSchedulerShutDown() {
        super.log.logf(FQCN, INFO, null, clientSchedulerShutDown$str());
    }
    protected String clientSchedulerShutDown$str() {
        return "ISPN032009: Red Hat Insight client shut down, it is not possible to schedule other tasks on it";
    }
}
