/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.util.List;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

@ProtoTypeId(value=6609)
public class PreparingDecisionFunction
extends TxFunction {
    private final List<WriteCommand> modifications;

    public PreparingDecisionFunction(List<WriteCommand> modifications) {
        this.modifications = modifications;
    }

    @ProtoFactory
    PreparingDecisionFunction(MarshallableList<WriteCommand> wrappedModifications) {
        this.modifications = MarshallableList.unwrap(wrappedModifications);
    }

    @ProtoField(number=1, name="modifications")
    MarshallableList<WriteCommand> getWrappedModifications() {
        return MarshallableList.create(this.modifications);
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            switch (state.getStatus()) {
                case ACTIVE: 
                case PREPARING: {
                    view.set((Object)state.markPreparing(this.modifications, this.timeService), new MetaParam.Writable[0]);
                    return Status.OK.value;
                }
            }
            return state.getStatus().value;
        }
        return Status.NO_TRANSACTION.value;
    }

    public String toString() {
        return "PreparingDecisionFunction{modifications=" + Util.toStr(this.modifications) + "}";
    }
}

