/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;

@ProtoTypeId(value=6601)
public class ConditionalMarkAsRollbackFunction
extends TxFunction {
    @ProtoField(value=1)
    final byte expectStatus;

    public ConditionalMarkAsRollbackFunction(Status expected) {
        this(expected.value);
    }

    @ProtoFactory
    ConditionalMarkAsRollbackFunction(byte expectStatus) {
        this.expectStatus = expectStatus;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isPresent()) {
            TxState state = (TxState)view.get();
            if (state.getStatus().value == this.expectStatus || state.getStatus() == Status.MARK_ROLLBACK) {
                view.set((Object)state.setStatus(Status.MARK_ROLLBACK, true, this.timeService), new MetaParam.Writable[0]);
                return Status.OK.value;
            }
            return Status.ERROR.value;
        }
        return Status.NO_TRANSACTION.value;
    }

    public String toString() {
        return "ConditionalMarkAsRollbackFunction{expectStatus=" + this.expectStatus + "}";
    }
}

