/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table;

import com.google.errorprone.annotations.Immutable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.transaction.xa.GlobalTransaction;

@Immutable
@ProtoTypeId(value=6616)
public class TxState {
    @ProtoField(value=1)
    final GlobalTransaction globalTransaction;
    @ProtoField(value=2)
    final Status status;
    @ProtoField(value=3)
    final boolean recoverable;
    @ProtoField(value=4)
    final long timeout;
    @ProtoField(value=5)
    final long lastAccessTimeNs;
    private final List<WriteCommand> modifications;

    public TxState(GlobalTransaction globalTransaction, boolean recoverable, long timeout, TimeService timeService) {
        this(globalTransaction, Status.ACTIVE, null, recoverable, timeout, timeService.time());
    }

    private TxState(GlobalTransaction globalTransaction, Status status, List<WriteCommand> modifications, boolean recoverable, long timeout, long accessTime) {
        this.globalTransaction = Objects.requireNonNull(globalTransaction);
        this.status = Objects.requireNonNull(status);
        this.modifications = modifications == null ? null : List.copyOf(modifications);
        this.recoverable = recoverable;
        this.timeout = timeout;
        this.lastAccessTimeNs = accessTime;
    }

    @ProtoFactory
    TxState(GlobalTransaction globalTransaction, Status status, boolean recoverable, long timeout, long lastAccessTimeNs, MarshallableList<WriteCommand> wrappedModifications) {
        this(globalTransaction, status, MarshallableList.unwrap(wrappedModifications), recoverable, timeout, lastAccessTimeNs);
    }

    @ProtoField(number=6, name="modification")
    MarshallableList<WriteCommand> getWrappedModifications() {
        return MarshallableList.create(this.modifications);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TxState markPreparing(List<WriteCommand> modifications, TimeService timeService) {
        return new TxState(this.globalTransaction, Status.PREPARING, modifications, this.recoverable, this.timeout, timeService.time());
    }

    public Address getOriginator() {
        return this.globalTransaction.getAddress();
    }

    public TxState setStatus(Status newStatus, boolean cleanupModification, TimeService timeService) {
        return new TxState(this.globalTransaction, newStatus, cleanupModification ? null : this.modifications, this.recoverable, this.timeout, timeService.time());
    }

    public Status getStatus() {
        return this.status;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxState txState = (TxState)o;
        return Objects.equals((Object)this.status, (Object)txState.status) && Objects.equals(this.globalTransaction, txState.globalTransaction);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.globalTransaction);
        result = 31 * result + Objects.hashCode((Object)this.status);
        return result;
    }

    public boolean hasTimedOut(long currentTimeNs) {
        long timeoutNs = TimeUnit.MILLISECONDS.toNanos(this.timeout);
        return this.lastAccessTimeNs + timeoutNs < currentTimeNs;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public boolean isSameAs(GlobalTransaction globalTransaction, boolean recoverable, long timeout) {
        return this.timeout == timeout && this.recoverable == recoverable && this.globalTransaction.equals((Object)globalTransaction) && this.status == Status.ACTIVE;
    }

    public String toString() {
        return "TxState{globalTransaction=" + String.valueOf(this.globalTransaction) + ", status=" + String.valueOf((Object)this.status) + ", modifications=" + String.valueOf(this.modifications) + ", recoverable=" + this.recoverable + ", timeout=" + this.timeout + ", lastAccessTime=" + this.lastAccessTimeNs + "}";
    }
}

