/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.SaslAuthenticationConfiguration;
import org.infinispan.server.core.configuration.SaslAuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerChildConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.TopologyCacheConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;

public class HotRodServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<HotRodServerConfiguration, HotRodServerConfigurationBuilder, SaslAuthenticationConfiguration>
implements Builder<HotRodServerConfiguration>,
HotRodServerChildConfigurationBuilder {
    private final SaslAuthenticationConfigurationBuilder authentication = new SaslAuthenticationConfigurationBuilder((ProtocolServerConfigurationChildBuilder)this);
    private final TopologyCacheConfigurationBuilder topologyCache = new TopologyCacheConfigurationBuilder();
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());
    private static final String DEFAULT_NAME = "hotrod";

    public HotRodServerConfigurationBuilder() {
        super(11222, HotRodServerConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public HotRodServerConfigurationBuilder self() {
        return this;
    }

    @Override
    public SaslAuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyHost(String proxyHost) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).set((Object)proxyHost);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder proxyPort(int proxyPort) {
        this.attributes.attribute(HotRodServerConfiguration.PROXY_PORT).set((Object)proxyPort);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyLockTimeout(long topologyLockTimeout) {
        this.topologyCache.lockTimeout(topologyLockTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyLockTimeout(String topologyLockTimeout) {
        this.topologyCache.lockTimeout(topologyLockTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyReplTimeout(long topologyReplTimeout) {
        this.topologyCache.replicationTimeout(topologyReplTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyReplTimeout(String topologyReplTimeout) {
        this.topologyCache.replicationTimeout(topologyReplTimeout);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyAwaitInitialTransfer(boolean topologyAwaitInitialTransfer) {
        this.topologyCache.awaitInitialTransfer(topologyAwaitInitialTransfer);
        return this;
    }

    @Override
    public HotRodServerConfigurationBuilder topologyNetworkPrefixOverride(boolean topologyNetworkPrefixOverride) {
        this.topologyCache.networkPrefixOverride(topologyNetworkPrefixOverride);
        return this;
    }

    public HotRodServerConfiguration create() {
        if (!this.attributes.attribute(ProtocolServerConfiguration.NAME).isModified()) {
            String socketBinding = this.socketBinding();
            this.name(DEFAULT_NAME + (String)(socketBinding == null ? "" : "-" + socketBinding));
        }
        return new HotRodServerConfiguration(this.attributes.protect(), this.topologyCache.create(), this.ssl.create(), this.authentication.create(), this.encryption.create(), this.ipFilter.create());
    }

    public HotRodServerConfigurationBuilder read(HotRodServerConfiguration template, Combine combine) {
        super.read((ProtocolServerConfiguration)template, combine);
        this.topologyCache.read(template.topologyCache(), combine);
        this.encryption.read(template.encryption(), combine);
        return this;
    }

    public void validate() {
        super.validate();
        if (this.attributes.attribute(HotRodServerConfiguration.PROXY_HOST).isNull() && this.attributes.attribute(ProtocolServerConfiguration.HOST).isNull()) {
            throw Log.CONFIG.missingHostAddress();
        }
        this.topologyCache.validate();
        this.encryption.validate();
    }

    public HotRodServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public HotRodServerConfiguration build() {
        return this.build(true);
    }
}

