/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.command.tx;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.server.hotrod.command.tx.AbstractForwardTxCommand;
import org.infinispan.server.hotrod.tx.operation.Util;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.BlockingManager;

@ProtoTypeId(value=6614)
public class ForwardCommitCommand
extends AbstractForwardTxCommand {
    @ProtoFactory
    public ForwardCommitCommand(ByteString cacheName, XidImpl xid, long timeout) {
        super(cacheName, xid, timeout);
    }

    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        BlockingManager bm = (BlockingManager)componentRegistry.getGlobalComponentRegistry().getComponent(BlockingManager.class);
        return bm.runBlocking(() -> {
            try {
                Util.commitLocalTransaction((AdvancedCache)componentRegistry.getCache().wired(), this.xid, this.timeout);
            }
            catch (HeuristicMixedException | HeuristicRollbackException | RollbackException e) {
                throw new RuntimeException(e);
            }
        }, (Object)"forward-commit");
    }

    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "ForwardCommitCommand{cacheName=" + String.valueOf(this.cacheName) + ", xid=" + String.valueOf(this.xid) + "}";
    }
}

