/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.exception.CounterNotFoundException;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.counter.impl.manager.InternalCounterAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;

class CounterRequestProcessor
extends BaseRequestProcessor {
    private ClientCounterManagerNotificationManager notificationManager;
    private EmbeddedCounterManager counterManager;

    CounterRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
    }

    private EmbeddedCounterManager counterManager(HotRodHeader header) {
        header.cacheName = "org.infinispan.COUNTER";
        if (this.counterManager == null) {
            this.counterManager = (EmbeddedCounterManager)EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.server.getCacheManager());
        }
        return this.counterManager;
    }

    private ClientCounterManagerNotificationManager notificationManager() {
        if (this.notificationManager == null) {
            this.notificationManager = this.server.getClientCounterNotificationManager();
        }
        return this.notificationManager;
    }

    void removeCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        CompletableFuture.supplyAsync(() -> this.notificationManager().removeCounterListener(listenerId, counterName), this.executor).whenCompleteAsync((status, throwable) -> this.listerOperationStatusHandler(header, (ListenerOperationStatus)((Object)status), (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void addCounterListener(HotRodHeader header, Subject subject, String counterName, byte[] listenerId) {
        CompletableFuture.supplyAsync(() -> this.notificationManager().addCounterListener(listenerId, header.getVersion(), counterName, this.channel, header.encoder()), this.executor).whenCompleteAsync((status, throwable) -> this.listerOperationStatusHandler(header, (ListenerOperationStatus)((Object)status), (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void getCounterNames(HotRodHeader header, Subject subject) {
        Collection counterNames = this.counterManager(header).getCounterNames();
        this.writeResponse(header, header.encoder().counterNamesResponse(header, this.server, this.channel, counterNames));
    }

    void counterRemove(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).removeAsync(counterName, true).whenCompleteAsync((___, throwable) -> this.voidResultHandler(header, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void counterCompareAndSwap(HotRodHeader header, Subject subject, String counterName, long expect, long update) {
        this.counterManager(header).getStrongCounterAsync(counterName).thenCompose(strongCounter -> strongCounter.compareAndSwap(expect, update)).whenCompleteAsync((returnValue, throwable) -> this.longResultHandler(header, (Long)returnValue, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void counterGet(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::value).whenCompleteAsync((value, throwable) -> this.longResultHandler(header, (Long)value, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void counterReset(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getOrCreateAsync(counterName).thenCompose(InternalCounterAdmin::reset).whenCompleteAsync((unused, throwable) -> this.voidResultHandler(header, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void counterAddAndGet(HotRodHeader header, Subject subject, String counterName, long value) {
        this.counterManager(header).getOrCreateAsync(counterName).thenAccept(counter -> {
            if (counter.isWeakCounter()) {
                counter.asWeakCounter().add(value).whenCompleteAsync((___, t) -> this.longResultHandler(header, 0L, (Throwable)t), (Executor)this.channel.eventLoop());
            } else {
                counter.asStrongCounter().addAndGet(value).whenCompleteAsync((rv, t) -> this.longResultHandler(header, (Long)rv, (Throwable)t), (Executor)this.channel.eventLoop());
            }
        }).exceptionallyAsync(throwable -> {
            this.checkCounterThrowable(header, (Throwable)throwable);
            return null;
        }, (Executor)this.channel.eventLoop());
    }

    void counterSet(HotRodHeader header, Subject subject, String counterName, long value) {
        this.counterManager(header).getStrongCounterAsync(counterName).thenCompose(strongCounter -> strongCounter.getAndSet(value)).whenCompleteAsync((returnValue, throwable) -> this.longResultHandler(header, (Long)returnValue, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void getCounterConfiguration(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).getConfigurationAsync(counterName).whenCompleteAsync((configuration, throwable) -> this.handleGetCounterConfiguration(header, (CounterConfiguration)configuration, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    private void handleGetCounterConfiguration(HotRodHeader header, CounterConfiguration configuration, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            ByteBuf response = configuration == null ? this.missingCounterResponse(header) : header.encoder().counterConfigurationResponse(header, this.server, this.channel, configuration);
            this.writeResponse(header, response);
        }
    }

    void isCounterDefined(HotRodHeader header, Subject subject, String counterName) {
        this.counterManager(header).isDefinedAsync(counterName).whenCompleteAsync((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    void createCounter(HotRodHeader header, Subject subject, String counterName, CounterConfiguration configuration) {
        this.counterManager(header).defineCounterAsync(counterName, configuration).whenCompleteAsync((value, throwable) -> this.booleanResultHandler(header, (Boolean)value, (Throwable)throwable), (Executor)this.channel.eventLoop());
    }

    private ByteBuf createResponseFrom(HotRodHeader header, ListenerOperationStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case ListenerOperationStatus.OK -> header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.OperationNotExecuted);
            case ListenerOperationStatus.OK_AND_CHANNEL_IN_USE -> header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success);
            case ListenerOperationStatus.COUNTER_NOT_FOUND -> this.missingCounterResponse(header);
        };
    }

    private void listerOperationStatusHandler(HotRodHeader header, ListenerOperationStatus status, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, this.createResponseFrom(header, status));
        }
    }

    private void checkCounterThrowable(HotRodHeader header, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterOutOfBoundsException) {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.NotExecutedWithPrevious));
        } else if (cause instanceof CounterNotFoundException) {
            this.writeResponse(header, this.missingCounterResponse(header));
        } else {
            this.writeException(header, cause);
        }
    }

    private ByteBuf missingCounterResponse(HotRodHeader header) {
        return header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.KeyDoesNotExist);
    }

    private void booleanResultHandler(HotRodHeader header, Boolean value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            OperationStatus status = value != false ? OperationStatus.Success : OperationStatus.OperationNotExecuted;
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, status));
        }
    }

    private void longResultHandler(HotRodHeader header, Long value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().longResponse(header, this.server, this.channel, value));
        }
    }

    private void voidResultHandler(HotRodHeader header, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(header, throwable);
        } else {
            this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
        }
    }
}

