/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api._private.CounterEncodeUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.hotrod.AccessLoggingHeader;
import org.infinispan.server.hotrod.BaseDecoder;
import org.infinispan.server.hotrod.BitShift;
import org.infinispan.server.hotrod.HotRodConstants;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.Intrinsics;
import org.infinispan.server.hotrod.InvalidMagicIdException;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.RequestParsingException;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.TransactionWrite;
import org.infinispan.server.hotrod.logging.HotRodAccessLogging;
import org.infinispan.server.hotrod.tx.ControlByte;

public class HotRodDecoder
extends BaseDecoder {
    private int state;
    private int requestBytes;
    private byte hr2x_timeUnits;
    private int hr2x_numEntries;
    private String hr2x_iterationId;
    private byte hr2x_controlByte;
    private int hr2x_bloomBits;
    private byte[] hr2x_otherParamValue;
    private byte[] hr2x_fixedArray;
    private byte[] hr2x_queryBytes;
    private byte hr2x_counterFlags;
    private long hr2x_expectValue;
    private ByteBuf hr2x_readable;
    private boolean hr2x_includeCurrentState;
    private String hr2x_taskParam;
    private String hr2x_otherParamName;
    private String hr2x_cacheName;
    private int hr2x_vInt;
    private MediaType hr2x_valueType;
    private long hr2x_initialValue;
    private int hr2x_numModifications;
    private byte[] hr2x_param;
    private String hr2x_authMech;
    private byte[] hr2x_authResponse;
    private int hr2x_otherParamsNum;
    private int hr2x_listenerInterests;
    private byte hr2x_numParams;
    private int hr2x_xidFormat;
    private String hr2x_filterFactory;
    private long hr2x_maxIdleLong;
    private HotRodOperation hr2x_operation;
    private Map<String, byte[]> hr2x_otherParams;
    private long hr2x_upperBound;
    private byte hr2x_version;
    private String hr2x_converterFactory;
    private boolean hr2x_lastPut;
    private int hr2x_int;
    private int hr2x_signedVInt;
    private boolean hr2x_supportsDuplicates;
    private MediaType hr2x_keyType;
    private String hr2x_filterConverterFactory;
    private Map<String, String> hr2x_mediaTypeParams;
    private long hr2x_versionRead;
    private int hr2x_lifespanInt;
    private String hr2x_mediaParamValue;
    private byte hr2x_intelligence;
    private long hr2x_long;
    private String hr2x_mediaParamName;
    private List<byte[]> hr2x_converterParams;
    private boolean hr2x_recoverable;
    private String hr2x_actualCacheName;
    private byte[] hr2x_bloomArray;
    private byte[] hr2x_value;
    private byte hr2x_branchLength;
    private String hr2x_optionalString;
    private byte[] hr2x_optionalArray;
    private boolean hr2x_bool;
    private byte hr2x_xidLength;
    private byte hr2x_mediaTypeDefinition;
    private Metadata.Builder hr2x_expiration;
    private List<byte[]> hr2x_filterParams;
    private int hr2x_offset;
    private ByteBuf hr2x_chunkBytes;
    private long hr2x_updateValue;
    private byte hr2x_txMarker;
    private boolean hr2x_useRawEvents;
    private int hr2x_chunkLength;
    private long hr2x_timeout;
    private String hr2x_taskName;
    private String hr2x_mediaTypeName;
    private long hr2x_lowerBound;
    private byte[] hr2x_taskParamValue;
    private ByteBuf hr2x_chunkedValue;
    private byte[] hr2x_key;
    private int hr2x_batchSize;
    private HotRodHeader hr2x_header;
    private int hr2x_scope;
    private long hr2x_lifespanLong;
    private Map<String, byte[]> hr2x_taskParams;
    private byte[] hr2x_array;
    private int hr2x_flags;
    private byte[] hr2x_listenerId;
    private byte[] hr2x_segmentMask;
    private byte hr2x_magic;
    private int hr2x_maxIdleInt;
    private boolean hr2x_onePhaseCommit;
    private long hr2x_entryVersion;
    private int hr2x_mediaTypeId;
    private boolean hr2x_includeMetadata;
    private byte hr2x_opCode;
    private Map<byte[], byte[]> hr2x_entryMap;
    private int hr2x_mediaTypeParamsNum;
    private long hr2x_messageId;
    private long hr2x_vLong;
    private List<byte[]> hr2x_filterConverterParams;
    private ByteBuf hr2x_retained;
    private int hr2x_numKeys;
    private Map<String, byte[]> hr2x_otherParamsRev;
    private MediaType hr2x_mediaType;
    private byte[] hr2x_branchId;
    private ByteBuf hr2x_retainedChunk;
    private int hr2x_intValue;
    private String hr2x_string;
    private byte hr2x_byte;
    private byte[] hr2x_transactionId;
    private MediaType hr2x_mediaTypeDescription;
    private String hr2x_counterName;
    private TransactionWrite hr2x_modification;
    private CounterConfiguration.Builder hr2x_counterConfiguration;
    private int hr2x_topologyId;
    private Set<byte[]> hr2x_keys;
    private XidImpl hr2x_xid;
    private List<TransactionWrite> hr2x_modifications;
    private final boolean accessLogging;
    private Temporal requestStart;
    private boolean deadEnd = false;

    public HotRodDecoder(EmbeddedCacheManager cacheManager, Executor executor, HotRodServer server) {
        super(cacheManager, executor, server);
        server.accessLogging();
        this.accessLogging = HotRodAccessLogging.isEnabled();
    }

    @Override
    protected HotRodHeader getHeader() {
        if (this.accessLogging && this.hr2x_header != null) {
            return new AccessLoggingHeader(this.hr2x_header, this.auth.getSubjectWithoutValidation(), this.hr2x_key != null ? this.hr2x_key : (byte[])this.hr2x_taskName, this.requestBytes, this.requestStart);
        }
        return this.hr2x_header;
    }

    protected int bytesAvailable(ByteBuf buf) {
        if (this.maxContentLength > 0) {
            return Math.max(this.maxContentLength - this.requestBytes - buf.readerIndex() + this.posBefore, 0);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int pos = buf.readerIndex();
        try {
            while (this.switch1_0(ctx, buf, out)) {
            }
        }
        catch (Throwable t) {
            this.exceptionally(ctx, t);
        }
        finally {
            this.requestBytes += buf.readerIndex() - pos;
        }
    }

    private boolean switch1_0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state >> 6) {
            case 0: {
                return this.switch0(ctx, buf, out);
            }
            case 1: {
                return this.switch1(ctx, buf, out);
            }
            case 2: {
                return this.switch2(ctx, buf, out);
            }
            case 3: {
                return this.switch3(ctx, buf, out);
            }
            case 4: {
                return this.switch4(ctx, buf, out);
            }
            case 5: {
                return this.switch5(ctx, buf, out);
            }
            case 6: {
                return this.switch6(ctx, buf, out);
            }
            case 7: {
                return this.switch7(ctx, buf, out);
            }
            case 8: {
                return this.switch8(ctx, buf, out);
            }
        }
        throw new IllegalStateException();
    }

    private boolean switch0(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 0: {
                this.reset();
                this.state = 1;
            }
            case 1: {
                this.posBefore = buf.readerIndex();
                this.state = 2;
            }
            case 2: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_magic = this.hr2x_byte;
                this.state = 3;
            }
            case 3: {
                if (this.accessLogging) {
                    this.requestStart = Instant.now();
                }
                this.state = 4;
            }
            case 4: {
                if (this.hr2x_magic != -96) {
                    this.state = 6;
                    return true;
                }
                this.deadEnd = false;
                this.state = 7;
                return true;
            }
            case 5: {
                if (log.isTraceEnabled()) {
                    log.tracef("Parsed header: %s", (Object)this.hr2x_header);
                }
                this.state = 64;
                return true;
            }
            case 6: {
                throw new InvalidMagicIdException("Error reading magic byte or message id: " + this.hr2x_magic);
            }
            case 7: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_messageId = this.hr2x_vLong;
                this.state = 8;
            }
            case 8: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_version = this.hr2x_byte;
                this.state = 9;
            }
            case 9: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_opCode = this.hr2x_byte;
                this.hr2x_operation = HotRodOperation.fromRequestOpCode(this.hr2x_byte);
                this.state = 10;
            }
            case 10: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_actualCacheName = this.hr2x_string;
                this.hr2x_cacheName = this.checkCacheReady(this.hr2x_actualCacheName);
                this.state = 11;
            }
            case 11: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_flags = this.hr2x_vInt;
                this.state = 12;
            }
            case 12: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intelligence = this.hr2x_byte;
                this.state = 13;
            }
            case 13: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_topologyId = this.hr2x_vInt;
                this.state = 14;
            }
            case 14: {
                if (this.hr2x_version < HotRodConstants.VERSION_20) {
                    this.state = 16;
                    return true;
                }
                this.hr2x_txMarker = 0;
                this.state = 15;
            }
            case 15: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 18;
                    return true;
                }
                this.hr2x_keyType = this.hr2x_mediaType = null;
                this.state = 17;
                return true;
            }
            case 16: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_txMarker = this.hr2x_byte;
                this.state = 15;
                return true;
            }
            case 17: {
                if (this.hr2x_version >= HotRodConstants.VERSION_28) {
                    this.state = 38;
                    return true;
                }
                this.hr2x_valueType = this.hr2x_mediaType = null;
                this.state = 37;
                return true;
            }
            case 18: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 19;
            }
            case 19: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 20;
                        return true;
                    }
                    case 1: {
                        this.state = 21;
                        return true;
                    }
                    case 2: {
                        this.state = 29;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 20: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 17;
                return true;
            }
            case 21: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 22;
            }
            case 22: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 24;
                return true;
            }
            case 23: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 17;
                return true;
            }
            case 24: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 25;
            }
            case 25: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 23;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 26;
            }
            case 26: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 27;
            }
            case 27: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 28;
            }
            case 28: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 25;
                return true;
            }
            case 29: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 30;
            }
            case 30: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 32;
                return true;
            }
            case 31: {
                this.hr2x_keyType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 17;
                return true;
            }
            case 32: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 33;
            }
            case 33: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 31;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 34;
            }
            case 34: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 35;
            }
            case 35: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 36;
            }
            case 36: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 33;
                return true;
            }
            case 37: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 57;
                    return true;
                }
                this.hr2x_otherParams = null;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType, this.hr2x_otherParams);
                this.state = 5;
                return true;
            }
            case 38: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeDefinition = this.hr2x_byte;
                this.state = 39;
            }
            case 39: {
                switch (this.hr2x_mediaTypeDefinition) {
                    case 0: {
                        this.state = 40;
                        return true;
                    }
                    case 1: {
                        this.state = 41;
                        return true;
                    }
                    case 2: {
                        this.state = 49;
                        return true;
                    }
                }
                throw new RequestParsingException("Unknown MediaType definition: " + this.hr2x_mediaTypeDefinition, this.hr2x_version, this.hr2x_messageId);
            }
            case 40: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.APPLICATION_UNKNOWN);
                this.state = 37;
                return true;
            }
            case 41: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeId = this.hr2x_vInt;
                this.state = 42;
            }
            case 42: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 44;
                return true;
            }
            case 43: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaTypeIds.getMediaType((Short)((short)this.hr2x_mediaTypeId)).withParameters(this.hr2x_mediaTypeParams));
                this.state = 37;
                return true;
            }
            case 44: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 45;
            }
            case 45: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 43;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 46;
            }
            case 46: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 47;
            }
            case 47: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 48;
            }
            case 48: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 45;
                return true;
            }
            case 49: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeName = this.hr2x_string;
                this.state = 50;
            }
            case 50: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaTypeParamsNum = this.hr2x_vInt;
                this.state = 52;
                return true;
            }
            case 51: {
                this.hr2x_valueType = this.hr2x_mediaType = (this.hr2x_mediaTypeDescription = MediaType.fromString((String)this.hr2x_mediaTypeName).withParameters(this.hr2x_mediaTypeParams));
                this.state = 37;
                return true;
            }
            case 52: {
                this.hr2x_mediaTypeParams = this.allocMap(this.hr2x_mediaTypeParamsNum);
                this.state = 53;
            }
            case 53: {
                if (this.hr2x_mediaTypeParamsNum == 0) {
                    this.state = 51;
                    return true;
                }
                --this.hr2x_mediaTypeParamsNum;
                this.state = 54;
            }
            case 54: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamName = this.hr2x_string;
                this.state = 55;
            }
            case 55: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_mediaParamValue = this.hr2x_string;
                this.state = 56;
            }
            case 56: {
                this.hr2x_mediaTypeParams.put(this.hr2x_mediaParamName, this.hr2x_mediaParamValue);
                this.state = 53;
                return true;
            }
            case 57: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamsNum = this.hr2x_vInt;
                this.state = 59;
                return true;
            }
            case 58: {
                this.hr2x_otherParams = this.hr2x_otherParamsRev;
                this.hr2x_header = new HotRodHeader(this.hr2x_operation, this.hr2x_version, this.hr2x_messageId, this.hr2x_cacheName, this.hr2x_flags, this.hr2x_intelligence, this.hr2x_topologyId, this.hr2x_keyType, this.hr2x_valueType, this.hr2x_otherParams);
                this.state = 5;
                return true;
            }
            case 59: {
                this.hr2x_otherParamsRev = this.allocMap(this.hr2x_otherParamsNum);
                this.state = 60;
            }
            case 60: {
                if (this.hr2x_otherParamsNum == 0) {
                    this.state = 58;
                    return true;
                }
                --this.hr2x_otherParamsNum;
                this.state = 61;
            }
            case 61: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamName = this.hr2x_string;
                this.state = 62;
            }
            case 62: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_otherParamValue = this.hr2x_array;
                this.state = 63;
            }
            case 63: {
                this.hr2x_otherParamsRev.put(this.hr2x_otherParamName, this.hr2x_otherParamValue);
                this.state = 60;
                return true;
            }
        }
        return true;
    }

    private boolean switch1(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 64: {
                return this.userSwitch64();
            }
            case 65: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 66;
            }
            case 66: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 68;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 70;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 75;
                return true;
            }
            case 67: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 79;
                return true;
            }
            case 68: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 69;
            }
            case 69: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 67;
                return true;
            }
            case 70: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 71;
            }
            case 71: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 73;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 72;
            }
            case 72: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 74;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 67;
                return true;
            }
            case 73: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 72;
                return true;
            }
            case 74: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 67;
                return true;
            }
            case 75: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 77;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 76;
            }
            case 76: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 78;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 67;
                return true;
            }
            case 77: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 76;
                return true;
            }
            case 78: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 67;
                return true;
            }
            case 79: {
                this.cacheProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 80: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 81;
            }
            case 81: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 82: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 83;
            }
            case 83: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 85;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 87;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 92;
                return true;
            }
            case 84: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 96;
                return true;
            }
            case 85: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 86;
            }
            case 86: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 84;
                return true;
            }
            case 87: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 88;
            }
            case 88: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 90;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 89;
            }
            case 89: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 91;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 84;
                return true;
            }
            case 90: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 89;
                return true;
            }
            case 91: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 84;
                return true;
            }
            case 92: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 94;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 93;
            }
            case 93: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 95;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 84;
                return true;
            }
            case 94: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 93;
                return true;
            }
            case 95: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 84;
                return true;
            }
            case 96: {
                this.cacheProcessor.putIfAbsent(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 97: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 98;
            }
            case 98: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 100;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 102;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 107;
                return true;
            }
            case 99: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 111;
                return true;
            }
            case 100: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 101;
            }
            case 101: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 99;
                return true;
            }
            case 102: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 103;
            }
            case 103: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 105;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 104;
            }
            case 104: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 106;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 99;
                return true;
            }
            case 105: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 104;
                return true;
            }
            case 106: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 99;
                return true;
            }
            case 107: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 109;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 108;
            }
            case 108: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 110;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 99;
                return true;
            }
            case 109: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 108;
                return true;
            }
            case 110: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 99;
                return true;
            }
            case 111: {
                this.cacheProcessor.replace(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 112: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 113;
            }
            case 113: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 115;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 117;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 122;
                return true;
            }
            case 114: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 126;
                return true;
            }
            case 115: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 116;
            }
            case 116: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 114;
                return true;
            }
            case 117: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 118;
            }
            case 118: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 120;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 119;
            }
            case 119: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 121;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 114;
                return true;
            }
            case 120: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 119;
                return true;
            }
            case 121: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 114;
                return true;
            }
            case 122: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 124;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 123;
            }
            case 123: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 125;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 114;
                return true;
            }
            case 124: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 123;
                return true;
            }
            case 125: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 114;
                return true;
            }
            case 126: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 127;
            }
            case 127: {
                this.cacheProcessor.replaceIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion, this.hr2x_value, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    private boolean switch2(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 128: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 129;
            }
            case 129: {
                this.cacheProcessor.remove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 130: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 131;
            }
            case 131: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 132;
            }
            case 132: {
                this.cacheProcessor.removeIfUnmodified(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 133: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 134;
            }
            case 134: {
                this.cacheProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 135: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 136;
            }
            case 136: {
                this.cacheProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key);
                this.state = 0;
                return true;
            }
            case 137: {
                this.cacheProcessor.clear(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 138: {
                this.cacheProcessor.stats(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 139: {
                this.cacheProcessor.ping(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 140: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 141;
            }
            case 141: {
                this.cacheProcessor.bulkGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_numKeys);
                this.state = 0;
                return true;
            }
            case 142: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 143;
            }
            case 143: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, 0);
                this.state = 0;
                return true;
            }
            case 144: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_scope = this.hr2x_vInt;
                this.state = 145;
            }
            case 145: {
                this.cacheProcessor.bulkGetKeys(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_scope);
                this.state = 0;
                return true;
            }
            case 146: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_queryBytes = this.hr2x_array;
                this.state = 147;
            }
            case 147: {
                this.cacheProcessor.query(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_queryBytes);
                this.state = 0;
                return true;
            }
            case 148: {
                this.auth.authMechList(this.getHeader());
                this.state = 0;
                return true;
            }
            case 149: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authMech = this.hr2x_string;
                this.state = 150;
            }
            case 150: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_authResponse = this.hr2x_array;
                this.state = 151;
            }
            case 151: {
                this.auth.auth(this.getHeader(), this.hr2x_authMech, this.hr2x_authResponse);
                this.state = 0;
                return true;
            }
            case 152: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 153;
            }
            case 153: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeCurrentState = this.hr2x_bool;
                this.state = 154;
            }
            case 154: {
                if (this.hr2x_version >= HotRodConstants.VERSION_26) {
                    this.state = 156;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_21) {
                    this.state = 172;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 187;
                return true;
            }
            case 155: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, this.hr2x_includeCurrentState, this.hr2x_filterFactory, this.hr2x_filterParams, this.hr2x_converterFactory, this.hr2x_converterParams, this.hr2x_useRawEvents, this.hr2x_listenerInterests, 0);
                this.state = 0;
                return true;
            }
            case 156: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 157;
            }
            case 157: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 159;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 158;
            }
            case 158: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 164;
                return true;
            }
            case 159: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 160;
            }
            case 160: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 161;
            }
            case 161: {
                if (this.hr2x_numParams == 0) {
                    this.state = 158;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 162;
            }
            case 162: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 163;
            }
            case 163: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 161;
                return true;
            }
            case 164: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 166;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 165;
            }
            case 165: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 171;
                return true;
            }
            case 166: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 167;
            }
            case 167: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 168;
            }
            case 168: {
                if (this.hr2x_numParams == 0) {
                    this.state = 165;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 169;
            }
            case 169: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 170;
            }
            case 170: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 168;
                return true;
            }
            case 171: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerInterests = this.hr2x_vInt;
                this.state = 155;
                return true;
            }
            case 172: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterFactory = this.hr2x_string;
                this.state = 173;
            }
            case 173: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 175;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 174;
            }
            case 174: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 180;
                return true;
            }
            case 175: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 176;
            }
            case 176: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 177;
            }
            case 177: {
                if (this.hr2x_numParams == 0) {
                    this.state = 174;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 178;
            }
            case 178: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 179;
            }
            case 179: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 177;
                return true;
            }
            case 180: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 182;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 181;
            }
            case 181: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_useRawEvents = this.hr2x_bool;
                this.state = 155;
                return true;
            }
            case 182: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 183;
            }
            case 183: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 184;
            }
            case 184: {
                if (this.hr2x_numParams == 0) {
                    this.state = 181;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 185;
            }
            case 185: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 186;
            }
            case 186: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 184;
                return true;
            }
            case 187: {
                if (!this.hr2x_filterFactory.isEmpty()) {
                    this.state = 189;
                    return true;
                }
                this.hr2x_filterParams = null;
                this.state = 188;
            }
            case 188: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_converterFactory = this.hr2x_string;
                this.state = 194;
                return true;
            }
            case 189: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 190;
            }
            case 190: {
                this.hr2x_filterParams = this.allocList(this.hr2x_numParams);
                this.state = 191;
            }
            case 191: {
                if (this.hr2x_numParams == 0) {
                    this.state = 188;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 192;
            }
        }
        return true;
    }

    private boolean switch3(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 192: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 193;
            }
            case 193: {
                this.hr2x_filterParams.add(this.hr2x_param);
                this.state = 191;
                return true;
            }
            case 194: {
                if (!this.hr2x_converterFactory.isEmpty()) {
                    this.state = 195;
                    return true;
                }
                this.hr2x_converterParams = null;
                this.state = 155;
                return true;
            }
            case 195: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 196;
            }
            case 196: {
                this.hr2x_converterParams = this.allocList(this.hr2x_numParams);
                this.state = 197;
            }
            case 197: {
                if (this.hr2x_numParams == 0) {
                    this.state = 155;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 198;
            }
            case 198: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 199;
            }
            case 199: {
                this.hr2x_converterParams.add(this.hr2x_param);
                this.state = 197;
                return true;
            }
            case 200: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 201;
            }
            case 201: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_bloomBits = this.hr2x_vInt;
                this.state = 202;
            }
            case 202: {
                this.cacheProcessor.addClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId, false, null, null, null, null, false, 14, this.hr2x_bloomBits);
                this.state = 0;
                return true;
            }
            case 203: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 204;
            }
            case 204: {
                this.cacheProcessor.removeClientListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 205: {
                this.cacheProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 206: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskName = this.hr2x_string;
                this.state = 207;
            }
            case 207: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 209;
                return true;
            }
            case 208: {
                this.taskProcessor.exec(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_taskName, this.hr2x_taskParams);
                this.state = 0;
                return true;
            }
            case 209: {
                this.hr2x_taskParams = this.allocMap(this.hr2x_numParams);
                this.state = 210;
            }
            case 210: {
                if (this.hr2x_numParams == 0) {
                    this.state = 208;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 211;
            }
            case 211: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParam = this.hr2x_string;
                this.state = 212;
            }
            case 212: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_taskParamValue = this.hr2x_array;
                this.state = 213;
            }
            case 213: {
                this.hr2x_taskParams.put(this.hr2x_taskParam, this.hr2x_taskParamValue);
                this.state = 210;
                return true;
            }
            case 214: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 216;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 218;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 223;
                return true;
            }
            case 215: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numEntries = this.hr2x_vInt;
                this.state = 228;
                return true;
            }
            case 216: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 217;
            }
            case 217: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 215;
                return true;
            }
            case 218: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 219;
            }
            case 219: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 221;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 220;
            }
            case 220: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 222;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 215;
                return true;
            }
            case 221: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 220;
                return true;
            }
            case 222: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 215;
                return true;
            }
            case 223: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 225;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 224;
            }
            case 224: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 226;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 215;
                return true;
            }
            case 225: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 224;
                return true;
            }
            case 226: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 215;
                return true;
            }
            case 227: {
                this.cacheProcessor.putAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_entryMap, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 228: {
                this.hr2x_entryMap = this.allocMap(this.hr2x_numEntries);
                this.state = 229;
            }
            case 229: {
                if (this.hr2x_numEntries == 0) {
                    this.state = 227;
                    return true;
                }
                --this.hr2x_numEntries;
                this.state = 230;
            }
            case 230: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 231;
            }
            case 231: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 232;
            }
            case 232: {
                this.hr2x_entryMap.put(this.hr2x_key, this.hr2x_value);
                this.state = 229;
                return true;
            }
            case 233: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numKeys = this.hr2x_vInt;
                this.state = 235;
                return true;
            }
            case 234: {
                this.cacheProcessor.getAll(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_keys);
                this.state = 0;
                return true;
            }
            case 235: {
                this.hr2x_keys = this.allocSet(this.hr2x_numKeys);
                this.state = 236;
            }
            case 236: {
                if (this.hr2x_numKeys == 0) {
                    this.state = 234;
                    return true;
                }
                --this.hr2x_numKeys;
                this.state = 237;
            }
            case 237: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 238;
            }
            case 238: {
                this.hr2x_keys.add(this.hr2x_key);
                this.state = 236;
                return true;
            }
            case 239: {
                int pos = buf.readerIndex();
                this.hr2x_optionalArray = Intrinsics.optionalArray(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_segmentMask = this.hr2x_optionalArray;
                this.state = 240;
            }
            case 240: {
                int pos = buf.readerIndex();
                this.hr2x_optionalString = Intrinsics.optionalString(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_filterConverterFactory = this.hr2x_optionalString;
                this.state = 241;
            }
            case 241: {
                if (this.hr2x_filterConverterFactory != null) {
                    this.state = 243;
                    return true;
                }
                this.hr2x_filterConverterParams = null;
                this.state = 242;
            }
            case 242: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_batchSize = this.hr2x_vInt;
                this.state = 248;
                return true;
            }
            case 243: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numParams = this.hr2x_byte;
                this.state = 244;
            }
            case 244: {
                this.hr2x_filterConverterParams = this.allocList(this.hr2x_numParams);
                this.state = 245;
            }
            case 245: {
                if (this.hr2x_numParams == 0) {
                    this.state = 242;
                    return true;
                }
                this.hr2x_numParams = (byte)(this.hr2x_numParams - 1);
                this.state = 246;
            }
            case 246: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_param = this.hr2x_array;
                this.state = 247;
            }
            case 247: {
                this.hr2x_filterConverterParams.add(this.hr2x_param);
                this.state = 245;
                return true;
            }
            case 248: {
                if (this.hr2x_version >= HotRodConstants.VERSION_24) {
                    this.state = 250;
                    return true;
                }
                this.hr2x_includeMetadata = false;
                this.state = 249;
            }
            case 249: {
                this.cacheProcessor.iterationStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_segmentMask, this.hr2x_filterConverterFactory, this.hr2x_filterConverterParams, this.hr2x_batchSize, this.hr2x_includeMetadata);
                this.state = 0;
                return true;
            }
            case 250: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_includeMetadata = this.hr2x_bool;
                this.state = 249;
                return true;
            }
            case 251: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 252;
            }
            case 252: {
                this.cacheProcessor.iterationNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 253: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_iterationId = this.hr2x_string;
                this.state = 254;
            }
            case 254: {
                this.cacheProcessor.iterationEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_iterationId);
                this.state = 0;
                return true;
            }
            case 255: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 256;
            }
        }
        return true;
    }

    private boolean switch4(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 256: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_offset = this.hr2x_vInt;
                this.state = 257;
            }
            case 257: {
                this.cacheProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_offset);
                this.state = 0;
                return true;
            }
            case 258: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 259;
            }
            case 259: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 261;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 263;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 268;
                return true;
            }
            case 260: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 272;
                return true;
            }
            case 261: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 262;
            }
            case 262: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 260;
                return true;
            }
            case 263: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 264;
            }
            case 264: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 266;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 265;
            }
            case 265: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 267;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 260;
                return true;
            }
            case 266: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 265;
                return true;
            }
            case 267: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 260;
                return true;
            }
            case 268: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 270;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 269;
            }
            case 269: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 271;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 260;
                return true;
            }
            case 270: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 269;
                return true;
            }
            case 271: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 260;
                return true;
            }
            case 272: {
                this.hr2x_chunkedValue = this.cacheProcessor.channel().alloc().buffer();
                this.hr2x_chunkLength = 1;
                this.state = 274;
                return true;
            }
            case 273: {
                this.cacheProcessor.putStream(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkedValue, this.hr2x_entryVersion, this.hr2x_expiration);
                this.state = 0;
                return true;
            }
            case 274: {
                if (this.hr2x_chunkLength == 0) {
                    this.state = 273;
                    return true;
                }
                --this.hr2x_chunkLength;
                this.state = 275;
            }
            case 275: {
                if (this.hr2x_version >= HotRodConstants.VERSION_41) {
                    this.state = 276;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 279;
                return true;
            }
            case 276: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 277;
            }
            case 277: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 278;
                    return true;
                }
                throw new RequestParsingException("Retained chunk requires a chunk length greater than 0", this.hr2x_version, this.hr2x_messageId);
            }
            case 278: {
                int pos = buf.readerIndex();
                this.hr2x_retained = Intrinsics.retained(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_retainedChunk = this.hr2x_retained;
                this.state = 274;
                return true;
            }
            case 279: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 281;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0, 0);
                this.state = 280;
            }
            case 280: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 274;
                return true;
            }
            case 281: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 280;
                return true;
            }
            case 282: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_bloomArray = this.hr2x_array;
                this.state = 283;
            }
            case 283: {
                this.cacheProcessor.updateBloomFilter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_bloomArray);
                this.state = 0;
                return true;
            }
            case 284: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 285;
            }
            case 285: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 287;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 289;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 294;
                return true;
            }
            case 286: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_entryVersion = this.hr2x_long;
                this.state = 298;
                return true;
            }
            case 287: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 288;
            }
            case 288: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 286;
                return true;
            }
            case 289: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 290;
            }
            case 290: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 292;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 291;
            }
            case 291: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 293;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 286;
                return true;
            }
            case 292: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 291;
                return true;
            }
            case 293: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 286;
                return true;
            }
            case 294: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 296;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 295;
            }
            case 295: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 297;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 286;
                return true;
            }
            case 296: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 295;
                return true;
            }
            case 297: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 286;
                return true;
            }
            case 298: {
                this.cacheProcessor.putStreamStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_expiration, this.hr2x_entryVersion);
                this.state = 0;
                return true;
            }
            case 299: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 300;
            }
            case 300: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lastPut = this.hr2x_bool;
                this.state = 301;
            }
            case 301: {
                if (this.hr2x_version >= HotRodConstants.VERSION_41) {
                    this.state = 303;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 306;
                return true;
            }
            case 302: {
                this.cacheProcessor.putStreamNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue, this.hr2x_lastPut, this.hr2x_retainedChunk);
                this.state = 0;
                return true;
            }
            case 303: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 304;
            }
            case 304: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 305;
                    return true;
                }
                throw new RequestParsingException("Retained chunk requires a chunk length greater than 0", this.hr2x_version, this.hr2x_messageId);
            }
            case 305: {
                int pos = buf.readerIndex();
                this.hr2x_retained = Intrinsics.retained(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_retainedChunk = this.hr2x_retained;
                this.state = 302;
                return true;
            }
            case 306: {
                if (this.hr2x_chunkLength > 0) {
                    this.state = 308;
                    return true;
                }
                this.hr2x_chunkBytes = this.cacheProcessor.channel().alloc().buffer(0, 0);
                this.state = 307;
            }
            case 307: {
                this.hr2x_chunkedValue.writeBytes(this.hr2x_chunkBytes, this.hr2x_chunkBytes.readerIndex() - this.hr2x_chunkLength, this.hr2x_chunkLength);
                this.state = 302;
                return true;
            }
            case 308: {
                int pos = buf.readerIndex();
                this.hr2x_readable = Intrinsics.readable(buf, this.hr2x_chunkLength);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkBytes = this.hr2x_readable;
                this.state = 307;
                return true;
            }
            case 309: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 310;
            }
            case 310: {
                this.cacheProcessor.putStreamEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 311: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 312;
            }
            case 312: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_chunkLength = this.hr2x_vInt;
                this.state = 313;
            }
            case 313: {
                this.cacheProcessor.getStreamStart(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_chunkLength);
                this.state = 0;
                return true;
            }
            case 314: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 315;
            }
            case 315: {
                this.cacheProcessor.getStreamNext(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 316: {
                int pos = buf.readerIndex();
                this.hr2x_int = Intrinsics.int_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_intValue = this.hr2x_int;
                this.state = 317;
            }
            case 317: {
                this.cacheProcessor.getStreamEnd(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_intValue);
                this.state = 0;
                return true;
            }
            case 318: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 320;
                return true;
            }
            case 319: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 326;
                return true;
            }
        }
        return true;
    }

    private boolean switch5(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 320: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 321;
            }
            case 321: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 323;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 322;
            }
            case 322: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 324;
                return true;
            }
            case 323: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 322;
                return true;
            }
            case 324: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 325;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 319;
                return true;
            }
            case 325: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 319;
                return true;
            }
            case 326: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 328;
                return true;
            }
            case 327: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, false, 60000L);
                this.state = 0;
                return true;
            }
            case 328: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 329;
            }
            case 329: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 327;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 330;
            }
            case 330: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 332;
                return true;
            }
            case 331: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 329;
                return true;
            }
            case 332: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 333;
            }
            case 333: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 335;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 334;
            }
            case 334: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 336;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 331;
                return true;
            }
            case 335: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 334;
                return true;
            }
            case 336: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 338;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 340;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 345;
                return true;
            }
            case 337: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 331;
                return true;
            }
            case 338: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 339;
            }
            case 339: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 337;
                return true;
            }
            case 340: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 341;
            }
            case 341: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 343;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 342;
            }
            case 342: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 344;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 337;
                return true;
            }
            case 343: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 342;
                return true;
            }
            case 344: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 337;
                return true;
            }
            case 345: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 347;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 346;
            }
            case 346: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 348;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 337;
                return true;
            }
            case 347: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 346;
                return true;
            }
            case 348: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 337;
                return true;
            }
            case 349: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 351;
                return true;
            }
            case 350: {
                this.cacheProcessor.commitTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 351: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 352;
            }
            case 352: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 354;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 353;
            }
            case 353: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 355;
                return true;
            }
            case 354: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 353;
                return true;
            }
            case 355: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 356;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 350;
                return true;
            }
            case 356: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 350;
                return true;
            }
            case 357: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 359;
                return true;
            }
            case 358: {
                this.cacheProcessor.rollbackTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 359: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 360;
            }
            case 360: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 362;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 361;
            }
            case 361: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 363;
                return true;
            }
            case 362: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 361;
                return true;
            }
            case 363: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 364;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 358;
                return true;
            }
            case 364: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 358;
                return true;
            }
            case 365: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 367;
                return true;
            }
            case 366: {
                this.cacheProcessor.forgetTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid);
                this.state = 0;
                return true;
            }
            case 367: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 368;
            }
            case 368: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 370;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 369;
            }
            case 369: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 371;
                return true;
            }
            case 370: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 369;
                return true;
            }
            case 371: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 372;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 366;
                return true;
            }
            case 372: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 366;
                return true;
            }
            case 373: {
                this.cacheProcessor.getPreparedTransactions(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 374: {
                int pos = buf.readerIndex();
                this.hr2x_signedVInt = Intrinsics.signedVInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidFormat = this.hr2x_signedVInt;
                this.state = 376;
                return true;
            }
            case 375: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_onePhaseCommit = this.hr2x_bool;
                this.state = 382;
                return true;
            }
            case 376: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_xidLength = this.hr2x_byte;
                this.state = 377;
            }
            case 377: {
                if (this.hr2x_xidLength > 0) {
                    this.state = 379;
                    return true;
                }
                this.hr2x_transactionId = Util.EMPTY_BYTE_ARRAY;
                this.state = 378;
            }
            case 378: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchLength = this.hr2x_byte;
                this.state = 380;
                return true;
            }
            case 379: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_xidLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_transactionId = this.hr2x_fixedArray;
                this.state = 378;
                return true;
            }
            case 380: {
                if (this.hr2x_branchLength > 0) {
                    this.state = 381;
                    return true;
                }
                this.hr2x_branchId = Util.EMPTY_BYTE_ARRAY;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 375;
                return true;
            }
            case 381: {
                int pos = buf.readerIndex();
                this.hr2x_fixedArray = Intrinsics.fixedArray(buf, this.hr2x_branchLength, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_branchId = this.hr2x_fixedArray;
                this.hr2x_xid = XidImpl.create((int)this.hr2x_xidFormat, (byte[])this.hr2x_transactionId, (byte[])this.hr2x_branchId);
                this.state = 375;
                return true;
            }
            case 382: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_recoverable = this.hr2x_bool;
                this.state = 383;
            }
            case 383: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeout = this.hr2x_long;
                this.state = 384;
            }
        }
        return true;
    }

    private boolean switch6(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 384: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_numModifications = this.hr2x_vInt;
                this.state = 386;
                return true;
            }
            case 385: {
                this.cacheProcessor.prepareTransaction(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_xid, this.hr2x_onePhaseCommit, this.hr2x_modifications, this.hr2x_recoverable, this.hr2x_timeout);
                this.state = 0;
                return true;
            }
            case 386: {
                this.hr2x_modifications = this.allocList(this.hr2x_numModifications);
                this.state = 387;
            }
            case 387: {
                if (this.hr2x_numModifications == 0) {
                    this.state = 385;
                    return true;
                }
                --this.hr2x_numModifications;
                this.state = 388;
            }
            case 388: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 390;
                return true;
            }
            case 389: {
                this.hr2x_modifications.add(this.hr2x_modification);
                this.state = 387;
                return true;
            }
            case 390: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_controlByte = this.hr2x_byte;
                this.state = 391;
            }
            case 391: {
                if (!ControlByte.NOT_READ.hasFlag(this.hr2x_controlByte) && !ControlByte.NON_EXISTING.hasFlag(this.hr2x_controlByte)) {
                    this.state = 393;
                    return true;
                }
                this.hr2x_versionRead = 0L;
                this.state = 392;
            }
            case 392: {
                if (!ControlByte.REMOVE_OP.hasFlag(this.hr2x_controlByte)) {
                    this.state = 394;
                    return true;
                }
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 389;
                return true;
            }
            case 393: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_versionRead = this.hr2x_entryVersion = this.hr2x_long;
                this.state = 392;
                return true;
            }
            case 394: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 396;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 398;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 403;
                return true;
            }
            case 395: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.hr2x_modification = new TransactionWrite(this.hr2x_key, this.hr2x_versionRead, this.hr2x_controlByte, this.hr2x_value, this.hr2x_expiration);
                this.state = 389;
                return true;
            }
            case 396: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 397;
            }
            case 397: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 395;
                return true;
            }
            case 398: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 399;
            }
            case 399: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 401;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 400;
            }
            case 400: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 402;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 395;
                return true;
            }
            case 401: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 400;
                return true;
            }
            case 402: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 395;
                return true;
            }
            case 403: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 405;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 404;
            }
            case 404: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 406;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 395;
                return true;
            }
            case 405: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 404;
                return true;
            }
            case 406: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 395;
                return true;
            }
            case 407: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 408;
            }
            case 408: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterFlags = this.hr2x_byte;
                this.state = 410;
                return true;
            }
            case 409: {
                this.counterProcessor.createCounter(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_counterConfiguration.build());
                this.state = 0;
                return true;
            }
            case 410: {
                this.hr2x_counterConfiguration = CounterConfiguration.builder((CounterType)CounterEncodeUtil.decodeType((byte)this.hr2x_counterFlags)).storage(CounterEncodeUtil.decodeStorage((byte)this.hr2x_counterFlags));
                this.state = 411;
            }
            case 411: {
                if ((this.hr2x_counterFlags & 1) == 1) {
                    this.state = 413;
                    return true;
                }
                this.state = 412;
            }
            case 412: {
                if ((this.hr2x_counterFlags & 2) == 2) {
                    this.state = 416;
                    return true;
                }
                this.state = 415;
                return true;
            }
            case 413: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.state = 414;
            }
            case 414: {
                this.hr2x_counterConfiguration.concurrencyLevel(this.hr2x_vInt);
                this.state = 412;
                return true;
            }
            case 415: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_initialValue = this.hr2x_long;
                this.hr2x_counterConfiguration = this.hr2x_counterConfiguration.initialValue(this.hr2x_initialValue);
                this.state = 409;
                return true;
            }
            case 416: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lowerBound = this.hr2x_long;
                this.state = 417;
            }
            case 417: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_upperBound = this.hr2x_long;
                this.state = 418;
            }
            case 418: {
                this.hr2x_counterConfiguration.lowerBound(this.hr2x_lowerBound).upperBound(this.hr2x_upperBound);
                this.state = 415;
                return true;
            }
            case 419: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 420;
            }
            case 420: {
                this.counterProcessor.getCounterConfiguration(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 421: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 422;
            }
            case 422: {
                this.counterProcessor.isCounterDefined(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 423: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 424;
            }
            case 424: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 425;
            }
            case 425: {
                this.counterProcessor.counterAddAndGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 426: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 427;
            }
            case 427: {
                this.counterProcessor.counterReset(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 428: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 429;
            }
            case 429: {
                this.counterProcessor.counterGet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 430: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 431;
            }
            case 431: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_expectValue = this.hr2x_long;
                this.state = 432;
            }
            case 432: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 433;
            }
            case 433: {
                this.counterProcessor.counterCompareAndSwap(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_expectValue, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 434: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 435;
            }
            case 435: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 436;
            }
            case 436: {
                this.counterProcessor.addCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 437: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 438;
            }
            case 438: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_listenerId = this.hr2x_array;
                this.state = 439;
            }
            case 439: {
                this.counterProcessor.removeCounterListener(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_listenerId);
                this.state = 0;
                return true;
            }
            case 440: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 441;
            }
            case 441: {
                this.counterProcessor.counterRemove(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName);
                this.state = 0;
                return true;
            }
            case 442: {
                this.counterProcessor.getCounterNames(this.getHeader(), this.auth.getSubject(this.hr2x_operation));
                this.state = 0;
                return true;
            }
            case 443: {
                int pos = buf.readerIndex();
                this.hr2x_string = Intrinsics.string(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_counterName = this.hr2x_string;
                this.state = 444;
            }
            case 444: {
                int pos = buf.readerIndex();
                this.hr2x_long = Intrinsics.long_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_updateValue = this.hr2x_long;
                this.state = 445;
            }
            case 445: {
                this.counterProcessor.counterSet(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_counterName, this.hr2x_updateValue);
                this.state = 0;
                return true;
            }
            case 446: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 447;
            }
            case 447: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 449;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 448;
            }
        }
        return true;
    }

    private boolean switch7(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 448: {
                this.multimapProcessor.get(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 449: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 448;
                return true;
            }
            case 450: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 451;
            }
            case 451: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 453;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 452;
            }
            case 452: {
                this.multimapProcessor.getWithMetadata(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 453: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 452;
                return true;
            }
            case 454: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 455;
            }
            case 455: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 457;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 459;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 464;
                return true;
            }
            case 456: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 468;
                return true;
            }
            case 457: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 458;
            }
            case 458: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 456;
                return true;
            }
            case 459: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 460;
            }
            case 460: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 462;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 461;
            }
            case 461: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 463;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 456;
                return true;
            }
            case 462: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 461;
                return true;
            }
            case 463: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 456;
                return true;
            }
            case 464: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 466;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 465;
            }
            case 465: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 467;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 456;
                return true;
            }
            case 466: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 465;
                return true;
            }
            case 467: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 456;
                return true;
            }
            case 468: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 470;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 469;
            }
            case 469: {
                this.multimapProcessor.put(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 470: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 469;
                return true;
            }
            case 471: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 472;
            }
            case 472: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 474;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 473;
            }
            case 473: {
                this.multimapProcessor.removeKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 474: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 473;
                return true;
            }
            case 475: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 476;
            }
            case 476: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 478;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 480;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 485;
                return true;
            }
            case 477: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 489;
                return true;
            }
            case 478: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 479;
            }
            case 479: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 477;
                return true;
            }
            case 480: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 481;
            }
            case 481: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 483;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 482;
            }
            case 482: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 484;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 477;
                return true;
            }
            case 483: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 482;
                return true;
            }
            case 484: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 477;
                return true;
            }
            case 485: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 487;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 486;
            }
            case 486: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 488;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 477;
                return true;
            }
            case 487: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 486;
                return true;
            }
            case 488: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 477;
                return true;
            }
            case 489: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 491;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 490;
            }
            case 490: {
                this.multimapProcessor.removeEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 491: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 490;
                return true;
            }
            case 492: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 494;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 493;
            }
            case 493: {
                this.multimapProcessor.size(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 494: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 493;
                return true;
            }
            case 495: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 496;
            }
            case 496: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 498;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 500;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 505;
                return true;
            }
            case 497: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 509;
                return true;
            }
            case 498: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 499;
            }
            case 499: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 497;
                return true;
            }
            case 500: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 501;
            }
            case 501: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 503;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 502;
            }
            case 502: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 504;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 497;
                return true;
            }
            case 503: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 502;
                return true;
            }
            case 504: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 497;
                return true;
            }
            case 505: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 507;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 506;
            }
            case 506: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 508;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 497;
                return true;
            }
            case 507: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 506;
                return true;
            }
            case 508: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 497;
                return true;
            }
            case 509: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 511;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 510;
            }
            case 510: {
                this.multimapProcessor.containsEntry(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 511: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 510;
                return true;
            }
        }
        return true;
    }

    private boolean switch8(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        switch (this.state) {
            case 512: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_key = this.hr2x_array;
                this.state = 513;
            }
            case 513: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 515;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 514;
            }
            case 514: {
                this.multimapProcessor.containsKey(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_key, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 515: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 514;
                return true;
            }
            case 516: {
                if (this.hr2x_version < HotRodConstants.VERSION_22) {
                    this.state = 518;
                    return true;
                }
                if (this.hr2x_version >= HotRodConstants.VERSION_30) {
                    this.state = 520;
                    return true;
                }
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 525;
                return true;
            }
            case 517: {
                int pos = buf.readerIndex();
                this.hr2x_array = Intrinsics.array(buf, this.bytesAvailable(buf));
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_value = this.hr2x_array;
                this.state = 529;
                return true;
            }
            case 518: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanInt = this.hr2x_vInt;
                this.state = 519;
            }
            case 519: {
                int pos = buf.readerIndex();
                this.hr2x_vInt = Intrinsics.vInt(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleInt = this.hr2x_vInt;
                this.hr2x_expiration = this.server.buildMetadata2x(this.defaultExpiration(this.hr2x_lifespanInt, this.hr2x_flags, ProtocolFlag.DefaultLifespan), TimeUnitValue.SECONDS, this.defaultExpiration(this.hr2x_maxIdleInt, this.hr2x_flags, ProtocolFlag.DefaultMaxIdle), TimeUnitValue.SECONDS);
                this.state = 517;
                return true;
            }
            case 520: {
                int pos = buf.readerIndex();
                this.hr2x_byte = Intrinsics.byte_(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_timeUnits = this.hr2x_byte;
                this.state = 521;
            }
            case 521: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 523;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 522;
            }
            case 522: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 524;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 517;
                return true;
            }
            case 523: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 522;
                return true;
            }
            case 524: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 517;
                return true;
            }
            case 525: {
                if ((this.hr2x_timeUnits & 0xF0) != 112 && (this.hr2x_timeUnits & 0xF0) != 128) {
                    this.state = 527;
                    return true;
                }
                this.hr2x_lifespanLong = 0L;
                this.state = 526;
            }
            case 526: {
                if ((this.hr2x_timeUnits & 0xF) != 7 && (this.hr2x_timeUnits & 0xF) != 8) {
                    this.state = 528;
                    return true;
                }
                this.hr2x_maxIdleLong = 0L;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 517;
                return true;
            }
            case 527: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_lifespanLong = this.hr2x_vLong;
                this.state = 526;
                return true;
            }
            case 528: {
                int pos = buf.readerIndex();
                this.hr2x_vLong = Intrinsics.vLong(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_maxIdleLong = this.hr2x_vLong;
                this.hr2x_expiration = this.server.buildMetadata2x(this.hr2x_lifespanLong, TimeUnitValue.decode(BitShift.right(this.hr2x_timeUnits, 4)), this.hr2x_maxIdleLong, TimeUnitValue.decode(BitShift.mask(this.hr2x_timeUnits, 15)));
                this.state = 517;
                return true;
            }
            case 529: {
                if (this.hr2x_version >= HotRodConstants.VERSION_40) {
                    this.state = 531;
                    return true;
                }
                this.hr2x_supportsDuplicates = false;
                this.state = 530;
            }
            case 530: {
                this.multimapProcessor.containsValue(this.getHeader(), this.auth.getSubject(this.hr2x_operation), this.hr2x_value, this.hr2x_supportsDuplicates);
                this.state = 0;
                return true;
            }
            case 531: {
                int pos = buf.readerIndex();
                this.hr2x_bool = Intrinsics.bool(buf);
                if (buf.readerIndex() == pos) {
                    return false;
                }
                this.hr2x_supportsDuplicates = this.hr2x_bool;
                this.state = 530;
                return true;
            }
        }
        return true;
    }

    private void deadEnd() {
        if (!this.deadEnd) {
            this.cacheProcessor.writeException(this.getHeader(), (Throwable)((Object)new RequestParsingException("Invalid state of parsing", this.hr2x_version, this.hr2x_messageId)));
            this.deadEnd = true;
        }
        this.state = 0;
    }

    private void exceptionally(ChannelHandlerContext ctx, Throwable t) throws Exception {
        if (t instanceof TooLongFrameException) {
            TooLongFrameException tlfe = (TooLongFrameException)t;
            log.requestTooLarge(ctx.channel(), tlfe);
            ctx.close();
            return;
        }
        log.trace((Object)"Parsing error", t);
        this.cacheProcessor.writeException(this.getHeader(), this.hr2x_messageId, t);
        this.state = 0;
    }

    private void reset() {
        this.requestBytes = 0;
        this.hr2x_timeUnits = 0;
        this.hr2x_numEntries = 0;
        this.hr2x_iterationId = null;
        this.hr2x_controlByte = 0;
        this.hr2x_bloomBits = 0;
        this.hr2x_otherParamValue = null;
        this.hr2x_fixedArray = null;
        this.hr2x_queryBytes = null;
        this.hr2x_counterFlags = 0;
        this.hr2x_expectValue = 0L;
        this.hr2x_readable = null;
        this.hr2x_includeCurrentState = false;
        this.hr2x_taskParam = null;
        this.hr2x_otherParamName = null;
        this.hr2x_cacheName = null;
        this.hr2x_vInt = 0;
        this.hr2x_valueType = null;
        this.hr2x_initialValue = 0L;
        this.hr2x_numModifications = 0;
        this.hr2x_param = null;
        this.hr2x_authMech = null;
        this.hr2x_authResponse = null;
        this.hr2x_otherParamsNum = 0;
        this.hr2x_listenerInterests = 0;
        this.hr2x_numParams = 0;
        this.hr2x_xidFormat = 0;
        this.hr2x_filterFactory = null;
        this.hr2x_maxIdleLong = 0L;
        this.hr2x_operation = null;
        this.hr2x_otherParams = null;
        this.hr2x_upperBound = 0L;
        this.hr2x_version = 0;
        this.hr2x_converterFactory = null;
        this.hr2x_lastPut = false;
        this.hr2x_int = 0;
        this.hr2x_signedVInt = 0;
        this.hr2x_supportsDuplicates = false;
        this.hr2x_keyType = null;
        this.hr2x_filterConverterFactory = null;
        this.hr2x_mediaTypeParams = null;
        this.hr2x_versionRead = 0L;
        this.hr2x_lifespanInt = 0;
        this.hr2x_mediaParamValue = null;
        this.hr2x_intelligence = 0;
        this.hr2x_long = 0L;
        this.hr2x_mediaParamName = null;
        this.hr2x_converterParams = null;
        this.hr2x_recoverable = false;
        this.hr2x_actualCacheName = null;
        this.hr2x_bloomArray = null;
        this.hr2x_value = null;
        this.hr2x_branchLength = 0;
        this.hr2x_optionalString = null;
        this.hr2x_optionalArray = null;
        this.hr2x_bool = false;
        this.hr2x_xidLength = 0;
        this.hr2x_mediaTypeDefinition = 0;
        this.hr2x_expiration = null;
        this.hr2x_filterParams = null;
        this.hr2x_offset = 0;
        this.hr2x_chunkBytes = null;
        this.hr2x_updateValue = 0L;
        this.hr2x_txMarker = 0;
        this.hr2x_useRawEvents = false;
        this.hr2x_chunkLength = 0;
        this.hr2x_timeout = 0L;
        this.hr2x_taskName = null;
        this.hr2x_mediaTypeName = null;
        this.hr2x_lowerBound = 0L;
        this.hr2x_taskParamValue = null;
        this.hr2x_chunkedValue = null;
        this.hr2x_key = null;
        this.hr2x_batchSize = 0;
        this.hr2x_header = null;
        this.hr2x_scope = 0;
        this.hr2x_lifespanLong = 0L;
        this.hr2x_taskParams = null;
        this.hr2x_array = null;
        this.hr2x_flags = 0;
        this.hr2x_listenerId = null;
        this.hr2x_segmentMask = null;
        this.hr2x_magic = 0;
        this.hr2x_maxIdleInt = 0;
        this.hr2x_onePhaseCommit = false;
        this.hr2x_entryVersion = 0L;
        this.hr2x_mediaTypeId = 0;
        this.hr2x_includeMetadata = false;
        this.hr2x_opCode = 0;
        this.hr2x_entryMap = null;
        this.hr2x_mediaTypeParamsNum = 0;
        this.hr2x_messageId = 0L;
        this.hr2x_vLong = 0L;
        this.hr2x_filterConverterParams = null;
        this.hr2x_retained = null;
        this.hr2x_numKeys = 0;
        this.hr2x_otherParamsRev = null;
        this.hr2x_mediaType = null;
        this.hr2x_branchId = null;
        this.hr2x_retainedChunk = null;
        this.hr2x_intValue = 0;
        this.hr2x_string = null;
        this.hr2x_byte = 0;
        this.hr2x_transactionId = null;
        this.hr2x_mediaTypeDescription = null;
        this.hr2x_counterName = null;
        this.hr2x_modification = null;
        this.hr2x_counterConfiguration = null;
        this.hr2x_topologyId = 0;
        this.hr2x_keys = null;
        this.hr2x_xid = null;
        this.hr2x_modifications = null;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    private boolean userSwitch64() throws Exception {
        switch (this.hr2x_opCode) {
            case 1: {
                this.state = 65;
                return true;
            }
            case 3: {
                this.state = 80;
                return true;
            }
            case 5: {
                this.state = 82;
                return true;
            }
            case 7: {
                this.state = 97;
                return true;
            }
            case 9: {
                this.state = 112;
                return true;
            }
            case 11: {
                this.state = 128;
                return true;
            }
            case 13: {
                this.state = 130;
                return true;
            }
            case 15: {
                this.state = 133;
                return true;
            }
            case 17: {
                this.state = 135;
                return true;
            }
            case 19: {
                this.state = 137;
                return true;
            }
            case 21: {
                this.state = 138;
                return true;
            }
            case 23: {
                this.state = 139;
                return true;
            }
            case 25: {
                this.state = 140;
                return true;
            }
            case 27: {
                this.state = 142;
                return true;
            }
            case 29: {
                this.state = 144;
                return true;
            }
            case 31: {
                this.state = 146;
                return true;
            }
            case 33: {
                this.state = 148;
                return true;
            }
            case 35: {
                this.state = 149;
                return true;
            }
            case 37: {
                this.state = 152;
                return true;
            }
            case 65: {
                this.state = 200;
                return true;
            }
            case 39: {
                this.state = 203;
                return true;
            }
            case 41: {
                this.state = 205;
                return true;
            }
            case 43: {
                this.state = 206;
                return true;
            }
            case 45: {
                this.state = 214;
                return true;
            }
            case 47: {
                this.state = 233;
                return true;
            }
            case 49: {
                this.state = 239;
                return true;
            }
            case 51: {
                this.state = 251;
                return true;
            }
            case 53: {
                this.state = 253;
                return true;
            }
            case 55: {
                this.state = 255;
                return true;
            }
            case 57: {
                this.state = 258;
                return true;
            }
            case 67: {
                this.state = 282;
                return true;
            }
            case -17: {
                this.state = 284;
                return true;
            }
            case -19: {
                this.state = 299;
                return true;
            }
            case -21: {
                this.state = 309;
                return true;
            }
            case -23: {
                this.state = 311;
                return true;
            }
            case -25: {
                this.state = 314;
                return true;
            }
            case -27: {
                this.state = 316;
                return true;
            }
            case 59: {
                this.state = 318;
                return true;
            }
            case 61: {
                this.state = 349;
                return true;
            }
            case 63: {
                this.state = 357;
                return true;
            }
            case 121: {
                this.state = 365;
                return true;
            }
            case 123: {
                this.state = 373;
                return true;
            }
            case 125: {
                this.state = 374;
                return true;
            }
            case 75: {
                this.state = 407;
                return true;
            }
            case 77: {
                this.state = 419;
                return true;
            }
            case 79: {
                this.state = 421;
                return true;
            }
            case 82: {
                this.state = 423;
                return true;
            }
            case 84: {
                this.state = 426;
                return true;
            }
            case 86: {
                this.state = 428;
                return true;
            }
            case 88: {
                this.state = 430;
                return true;
            }
            case 90: {
                this.state = 434;
                return true;
            }
            case 92: {
                this.state = 437;
                return true;
            }
            case 94: {
                this.state = 440;
                return true;
            }
            case 100: {
                this.state = 442;
                return true;
            }
            case 127: {
                this.state = 443;
                return true;
            }
            case 103: {
                this.state = 446;
                return true;
            }
            case 105: {
                this.state = 450;
                return true;
            }
            case 107: {
                this.state = 454;
                return true;
            }
            case 109: {
                this.state = 471;
                return true;
            }
            case 111: {
                this.state = 475;
                return true;
            }
            case 113: {
                this.state = 492;
                return true;
            }
            case 115: {
                this.state = 495;
                return true;
            }
            case 117: {
                this.state = 512;
                return true;
            }
            case 119: {
                this.state = 516;
                return true;
            }
        }
        throw new HotRodUnknownOperationException("Unknown operation " + this.hr2x_opCode, this.hr2x_version, this.hr2x_messageId);
    }
}

