/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.server.core.transport.ExtendedByteBufJava;

public class Intrinsics {
    public static int vInt(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
    }

    public static int signedVInt(ByteBuf buf) {
        buf.markReaderIndex();
        return SignedNumeric.decode((int)ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf));
    }

    public static long vLong(ByteBuf buf) {
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeVLong((ByteBuf)buf);
    }

    public static long long_(ByteBuf buf) {
        if (buf.readableBytes() >= 8) {
            return buf.readLong();
        }
        return 0L;
    }

    public static byte byte_(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte();
        }
        return 0;
    }

    public static int int_(ByteBuf buffer) {
        if (buffer.readableBytes() >= 4) {
            return buffer.readInt();
        }
        return 0;
    }

    public static boolean bool(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte() != 0;
        }
        return false;
    }

    private static void assertArrayLength(int length, int lengthMaximum) {
        if (lengthMaximum >= 0 && length > lengthMaximum) {
            throw new TooLongFrameException("Array length " + length + " exceeded " + lengthMaximum);
        }
    }

    public static byte[] array(ByteBuf buf, int lengthMaximum) {
        buf.markReaderIndex();
        int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
        if (length == Integer.MIN_VALUE) {
            return null;
        }
        Intrinsics.assertArrayLength(length, lengthMaximum);
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf, (int)length);
    }

    public static byte[] fixedArray(ByteBuf buf, int length, int lengthMaximum) {
        Intrinsics.assertArrayLength(length, lengthMaximum);
        buf.markReaderIndex();
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf, (int)length);
    }

    public static String string(ByteBuf buf, int lengthMaximum) {
        buf.markReaderIndex();
        int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
        if (length == Integer.MIN_VALUE) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        Intrinsics.assertArrayLength(length, lengthMaximum);
        if (!buf.isReadable(length)) {
            buf.resetReaderIndex();
            return null;
        }
        int startIndex = buf.readerIndex();
        buf.skipBytes(length);
        return buf.toString(startIndex, length, StandardCharsets.UTF_8);
    }

    public static byte[] optionalArray(ByteBuf buf, int lengthMaximum) {
        buf.markReaderIndex();
        int pos = buf.readerIndex();
        int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buf);
        if (pos == buf.readerIndex()) {
            return null;
        }
        if ((length = SignedNumeric.decode((int)length)) < 0) {
            return null;
        }
        Intrinsics.assertArrayLength(length, lengthMaximum);
        return ExtendedByteBufJava.readMaybeRangedBytes((ByteBuf)buf, (int)length);
    }

    public static String optionalString(ByteBuf buf, int lengthMaximum) {
        byte[] bytes = Intrinsics.optionalArray(buf, lengthMaximum);
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        return new String(bytes, CharsetUtil.UTF_8);
    }

    public static ByteBuf readable(ByteBuf buf, int length) {
        if (buf.readableBytes() >= length) {
            buf.readerIndex(buf.readerIndex() + length);
            return buf;
        }
        return null;
    }

    public static ByteBuf retained(ByteBuf buf, int length) {
        if (buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

