/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.EnumSet;
import org.infinispan.server.hotrod.OpReqs;

public enum HotRodOperation {
    PUT(1, 2, EnumSet.of(OpReqs.REQUIRES_KEY, new OpReqs[]{OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE, OpReqs.CAN_SKIP_CACHE_LOAD})),
    PUT_IF_ABSENT(5, 6, EnumSet.of(OpReqs.REQUIRES_KEY, new OpReqs[]{OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.IS_CONDITIONAL, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE})),
    REPLACE(7, 8, EnumSet.of(OpReqs.REQUIRES_KEY, new OpReqs[]{OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.IS_CONDITIONAL, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE})),
    REPLACE_IF_UNMODIFIED(9, 10, EnumSet.of(OpReqs.REQUIRES_KEY, new OpReqs[]{OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.IS_CONDITIONAL, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE})),
    CONTAINS_KEY(15, 16, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    GET(3, 4, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    GET_WITH_VERSION(17, 18, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    GET_WITH_METADATA(27, 28, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    REMOVE(11, 12, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE, OpReqs.CAN_SKIP_CACHE_LOAD)),
    REMOVE_IF_UNMODIFIED(13, 14, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.IS_CONDITIONAL, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_RETURN_PREVIOUS_VALUE)),
    PING(23, 24, EnumSet.noneOf(OpReqs.class)),
    STATS(21, 22, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    CLEAR(19, 20, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    SIZE(41, 42, EnumSet.of(OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    AUTH_MECH_LIST(33, 34, EnumSet.noneOf(OpReqs.class)),
    AUTH(35, 36, EnumSet.noneOf(OpReqs.class)),
    EXEC(43, 44, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    BULK_GET(25, 26, EnumSet.of(OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    BULK_GET_KEYS(29, 30, EnumSet.of(OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    QUERY(31, 32, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ADD_CLIENT_LISTENER(37, 38, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    REMOVE_CLIENT_LISTENER(39, 40, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ITERATION_START(49, 50, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ITERATION_NEXT(51, 52, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ITERATION_END(53, 54, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ADD_BLOOM_FILTER_CLIENT_LISTENER(65, 66, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    UPDATE_BLOOM_FILTER(67, 68, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    PUT_ALL(45, 46, EnumSet.of(OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_SKIP_CACHE_LOAD)),
    GET_ALL(47, 48, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    GET_STREAM(55, 56, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    PUT_STREAM(57, 58, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_INDEXING, OpReqs.CAN_SKIP_CACHE_LOAD)),
    START_PUT_STREAM(239, 238, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH)),
    NEXT_PUT_STREAM_REQUEST(237, 236, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    END_PUT_STREAM_REQUEST(235, 234, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    START_GET_STREAM_REQUEST(233, 232, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH)),
    NEXT_GET_STREAM_REQUEST(231, 230, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    END_GET_STREAM_REQUEST(229, 228, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    PREPARE_TX(59, 60, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COMMIT_TX(61, 62, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    ROLLBACK_TX(63, 64, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    FORGET_TX(121, 122, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    FETCH_TX_RECOVERY(123, 124, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    PREPARE_TX_2(125, 126, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_CREATE(75, 76, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_GET_CONFIGURATION(77, 78, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_IS_DEFINED(79, 81, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_ADD_AND_GET(82, 83, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_RESET(84, 85, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_GET(86, 87, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_CAS(88, 89, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_ADD_LISTENER(90, 91, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_REMOVE_LISTENER(92, 93, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_REMOVE(94, 95, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_GET_NAMES(100, 101, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    COUNTER_GET_AND_SET(127, 128, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    GET_MULTIMAP(103, 104, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    GET_MULTIMAP_WITH_METADATA(105, 106, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    PUT_MULTIMAP(107, 108, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    REMOVE_MULTIMAP(109, 110, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    REMOVE_ENTRY_MULTIMAP(111, 112, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    SIZE_MULTIMAP(113, 114, EnumSet.of(OpReqs.REQUIRES_AUTH)),
    CONTAINS_ENTRY_MULTIMAP(115, 116, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    CONTAINS_KEY_MULTIMAP(117, 118, EnumSet.of(OpReqs.REQUIRES_KEY, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    CONTAINS_VALUE_MULTIMAP(119, 120, EnumSet.of(OpReqs.REQUIRES_VALUE, OpReqs.REQUIRES_AUTH, OpReqs.CAN_SKIP_CACHE_LOAD)),
    ERROR(80),
    CACHE_ENTRY_CREATED_EVENT(96),
    CACHE_ENTRY_MODIFIED_EVENT(97),
    CACHE_ENTRY_REMOVED_EVENT(98),
    CACHE_ENTRY_EXPIRED_EVENT(99),
    COUNTER_EVENT(102);

    private final int requestOpCode;
    private final int responseOpCode;
    private final boolean requiresAuthentication;
    private final boolean canSkipIndexing;
    private final boolean canSkipCacheLoading;
    private final boolean canReturnPreviousValue;
    private final boolean isConditional;
    private static final HotRodOperation[] REQUEST_OPCODES;
    private static final HotRodOperation[] RESPONSE_OPCODES;
    public static final int REQUEST_COUNT;
    static final HotRodOperation[] VALUES;

    private HotRodOperation(int requestOpCode, int responseOpCode, EnumSet<OpReqs> opRequirements) {
        this.requestOpCode = requestOpCode;
        this.responseOpCode = responseOpCode;
        this.requiresAuthentication = opRequirements.contains((Object)OpReqs.REQUIRES_AUTH);
        this.canSkipIndexing = opRequirements.contains((Object)OpReqs.CAN_SKIP_INDEXING);
        this.canSkipCacheLoading = opRequirements.contains((Object)OpReqs.CAN_SKIP_CACHE_LOAD);
        this.canReturnPreviousValue = opRequirements.contains((Object)OpReqs.CAN_RETURN_PREVIOUS_VALUE);
        this.isConditional = opRequirements.contains((Object)OpReqs.IS_CONDITIONAL);
    }

    private HotRodOperation(int responseOpCode) {
        this(0, responseOpCode, EnumSet.noneOf(OpReqs.class));
    }

    public int getRequestOpCode() {
        return this.requestOpCode;
    }

    public int getResponseOpCode() {
        return this.responseOpCode;
    }

    boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    boolean canSkipIndexing() {
        return this.canSkipIndexing;
    }

    boolean canSkipCacheLoading() {
        return this.canSkipCacheLoading;
    }

    boolean isNotConditionalAndCanReturnPrevious() {
        return this == PUT;
    }

    boolean canReturnPreviousValue() {
        return this.canReturnPreviousValue;
    }

    boolean isConditional() {
        return this.isConditional;
    }

    public static HotRodOperation fromRequestOpCode(byte op) {
        return REQUEST_OPCODES[op & 0xFF];
    }

    public static HotRodOperation fromResponseOpCode(byte op) {
        return RESPONSE_OPCODES[op & 0xFF];
    }

    static {
        VALUES = HotRodOperation.values();
        REQUEST_OPCODES = new HotRodOperation[256];
        RESPONSE_OPCODES = new HotRodOperation[256];
        int requestCount = 0;
        for (HotRodOperation op : VALUES) {
            if (op.requestOpCode > 0) {
                HotRodOperation.REQUEST_OPCODES[op.requestOpCode] = op;
                ++requestCount;
            }
            if (op.responseOpCode <= 0) continue;
            HotRodOperation.RESPONSE_OPCODES[op.responseOpCode] = op;
        }
        REQUEST_COUNT = requestCount;
    }
}

