/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.EnumSet;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.hotrod.GlobalContextInitializerImpl;
import org.infinispan.server.hotrod.tx.ServerTransactionOriginatorChecker;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;

@InfinispanModule(name="server-hotrod", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    public static final String GLOBAL_TX_TABLE_CACHE_NAME = "org.infinispan.CLIENT_SERVER_TX_TABLE";
    @GuardedBy(value="this")
    private boolean registered = false;
    private GlobalComponentRegistry globalComponentRegistry;
    private GlobalConfiguration globalCfg;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        this.globalComponentRegistry = gcr;
        this.globalCfg = globalCfg;
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)new GlobalContextInitializerImpl());
        this.registerGlobalTxTable();
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        this.registerServerTransactionTable(cr, cacheName);
    }

    private void registerServerTransactionTable(ComponentRegistry componentRegistry, String cacheName) {
        if (GLOBAL_TX_TABLE_CACHE_NAME.equals(cacheName) || !((Configuration)componentRegistry.getComponent(Configuration.class)).transaction().transactionMode().isTransactional()) {
            return;
        }
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.globalComponentRegistry.getComponent(EmbeddedCacheManager.class);
        this.createGlobalTxTable(cacheManager);
        BasicComponentRegistry basicComponentRegistry = (BasicComponentRegistry)componentRegistry.getComponent(BasicComponentRegistry.class);
        basicComponentRegistry.replaceComponent(PerCacheTxTable.class.getName(), (Object)new PerCacheTxTable(), true);
        basicComponentRegistry.replaceComponent(TransactionOriginatorChecker.class.getName(), (Object)new ServerTransactionOriginatorChecker(), true);
        componentRegistry.rewire();
    }

    private void registerGlobalTxTable() {
        InternalCacheRegistry registry = (InternalCacheRegistry)this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(this.globalCfg.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        registry.registerInternalCache(GLOBAL_TX_TABLE_CACHE_NAME, builder.build(), EnumSet.noneOf(InternalCacheRegistry.Flag.class));
    }

    private synchronized void createGlobalTxTable(EmbeddedCacheManager cacheManager) {
        if (!this.registered) {
            Cache cache = cacheManager.getCache(GLOBAL_TX_TABLE_CACHE_NAME);
            GlobalTxTable txTable = new GlobalTxTable((Cache<CacheXid, TxState>)cache, this.globalComponentRegistry);
            this.globalComponentRegistry.registerComponent((Object)txTable, GlobalTxTable.class);
            this.registered = true;
        }
    }
}

