/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.iteration;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.time.TimeServiceTicker;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.iteration.DefaultIterationState;
import org.infinispan.server.core.iteration.IterableIterationResult;
import org.infinispan.server.core.iteration.IterationFilter;
import org.infinispan.server.core.iteration.IterationInitializationContext;
import org.infinispan.server.core.iteration.IterationManager;
import org.infinispan.server.core.iteration.IterationSegmentsListener;
import org.infinispan.server.core.iteration.IterationState;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.OnChannelCloseReaper;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.WithinThreadExecutor;

public class DefaultIterationManager
implements IterationManager {
    private static final Log log = (Log)LogFactory.getLog(DefaultIterationManager.class, Log.class);
    private final Cache<String, DefaultIterationState> iterationStateMap;
    private static final AtomicLong globalIterationId = new AtomicLong(0L);
    private final Map<String, KeyValueFilterConverterFactory> filterConverterFactoryMap = new ConcurrentHashMap<String, KeyValueFilterConverterFactory>();

    public DefaultIterationManager(TimeService timeService) {
        Caffeine builder = Caffeine.newBuilder();
        builder.expireAfterAccess(5L, TimeUnit.MINUTES).removalListener((key, value, cause) -> {
            value.close();
            if (cause.wasEvicted()) {
                log.removedUnclosedIterator((String)key);
            }
        }).ticker((Ticker)new TimeServiceTicker(timeService)).executor((Executor)new WithinThreadExecutor());
        this.iterationStateMap = builder.build();
    }

    @Override
    public IterationState start(AdvancedCache cache, BitSet segments, String filterConverterFactory, List<byte[]> filterConverterParams, MediaType requestValueType, int batch, boolean metadata, DeliveryGuarantee guarantee, IterationInitializationContext ctx) {
        CacheStream filteredStream;
        CacheStream<CacheEntry<Object, Object>> stream;
        String iterationId = String.valueOf(globalIterationId.incrementAndGet());
        EmbeddedCacheManager cacheManager = SecurityActions.getEmbeddedCacheManager((AdvancedCache)cache);
        EncoderRegistry encoderRegistry = (EncoderRegistry)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(EncoderRegistry.class);
        DataConversion valueDataConversion = cache.getValueDataConversion();
        Function<Object, Object> unmarshaller = p -> encoderRegistry.convert(p, requestValueType, MediaType.APPLICATION_OBJECT);
        MediaType storageMediaType = valueDataConversion.getRequestMediaType() != null && valueDataConversion.getRequestMediaType() != MediaType.APPLICATION_UNKNOWN ? valueDataConversion.getRequestMediaType() : valueDataConversion.getStorageMediaType();
        IterationSegmentsListener segmentListener = new IterationSegmentsListener();
        Function<Object, Object> resultTransformer = Function.identity();
        AdvancedCache iterationCache = cache;
        if (filterConverterFactory == null) {
            stream = this.baseStream(cache, ctx);
            if (segments != null) {
                stream.filterKeySegments(IntSets.from((PrimitiveIterator.OfInt)segments.stream().iterator()));
            }
            filteredStream = stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener);
        } else {
            KeyValueFilterConverterFactory factory = this.getFactory(filterConverterFactory);
            KeyValuePair<KeyValueFilterConverter, Boolean> filter = this.buildFilter(factory, (byte[][])filterConverterParams.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY), unmarshaller);
            KeyValueFilterConverter customFilter = (KeyValueFilterConverter)filter.getKey();
            MediaType filterMediaType = customFilter.format();
            if (filterMediaType != null && filterMediaType.equals((Object)storageMediaType)) {
                iterationCache = cache.withMediaType(filterMediaType, filterMediaType);
            }
            stream = this.baseStream(iterationCache, ctx);
            if (segments != null) {
                stream.filterKeySegments(IntSets.from((PrimitiveIterator.OfInt)segments.stream().iterator()));
            }
            IterationFilter iterationFilter = new IterationFilter(storageMediaType, requestValueType, (KeyValueFilterConverter)filter.getKey());
            filteredStream = CacheFilters.filterAndConvert((CacheStream)stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener), iterationFilter);
            if (filterMediaType != null && !storageMediaType.equals((Object)requestValueType)) {
                resultTransformer = arg_0 -> ((DataConversion)valueDataConversion).fromStorage(arg_0);
            }
        }
        Iterator<CacheEntry<Object, Object>> iterator = filteredStream.iterator();
        DefaultIterationState iterationState = new DefaultIterationState(iterationId, segmentListener, iterator, stream, batch, metadata, resultTransformer, new OnChannelCloseReaper(___ -> this.close(iterationId)));
        this.iterationStateMap.put((Object)iterationId, (Object)iterationState);
        if (log.isTraceEnabled()) {
            log.tracef("Started iteration %s", iterationId);
        }
        return iterationState;
    }

    protected CacheStream<CacheEntry<Object, Object>> baseStream(AdvancedCache cache, IterationInitializationContext ctx) {
        return cache.cacheEntrySet().stream();
    }

    private KeyValueFilterConverterFactory getFactory(String name) {
        KeyValueFilterConverterFactory factory = this.filterConverterFactoryMap.get(name);
        if (factory == null) {
            throw log.missingKeyValueFilterConverterFactory(name);
        }
        return factory;
    }

    private KeyValuePair<KeyValueFilterConverter, Boolean> buildFilter(KeyValueFilterConverterFactory factory, byte[][] params, Function<Object, Object> unmarshallParam) {
        if (factory instanceof ParamKeyValueFilterConverterFactory) {
            ParamKeyValueFilterConverterFactory paramFactory = (ParamKeyValueFilterConverterFactory)factory;
            Object unmarshallParams = paramFactory.binaryParam() ? params : (Object)Arrays.stream(params).map(unmarshallParam).toArray();
            return new KeyValuePair((Object)paramFactory.getFilterConverter((Object[])unmarshallParams), (Object)paramFactory.binaryParam());
        }
        return new KeyValuePair((Object)factory.getFilterConverter(), (Object)false);
    }

    @Override
    public IterableIterationResult next(String iterationId, int batch) {
        DefaultIterationState iterationState = (DefaultIterationState)this.iterationStateMap.getIfPresent((Object)iterationId);
        if (iterationState != null) {
            ArrayList<CacheEntry> entries;
            int i = 0;
            if (batch == Integer.MAX_VALUE) {
                entries = new ArrayList<CacheEntry>();
                while (iterationState.iterator.hasNext()) {
                    entries.add(iterationState.iterator.next());
                }
            } else {
                entries = new ArrayList();
                while (i++ < iterationState.batch && iterationState.iterator.hasNext()) {
                    entries.add(iterationState.iterator.next());
                }
            }
            return new IterableIterationResult(iterationState.listener.getFinished(entries.isEmpty()), iterationState.iterator.hasNext() ? IterableIterationResult.Status.Success : IterableIterationResult.Status.Finished, entries, iterationState.metadata, iterationState.resultFunction);
        }
        return new IterableIterationResult(Collections.emptySet(), IterableIterationResult.Status.InvalidIteration, Collections.emptyList(), false, Function.identity());
    }

    @Override
    public IterationState close(String iterationId) {
        DefaultIterationState iterationState = (DefaultIterationState)this.iterationStateMap.getIfPresent((Object)iterationId);
        if (iterationState != null) {
            this.iterationStateMap.invalidate((Object)iterationId);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Closed iteration %s", iterationId);
        }
        return iterationState;
    }

    @Override
    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.filterConverterFactoryMap.put(name, factory);
    }

    @Override
    public void removeKeyValueFilterConverterFactory(String name) {
        this.filterConverterFactoryMap.remove(name);
    }

    @Override
    public int activeIterations() {
        this.iterationStateMap.cleanUp();
        return this.iterationStateMap.asMap().size();
    }
}

