/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.encoding.impl.TwoStepTranscoder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.EntityLoaderFactory;
import org.infinispan.query.impl.LifecycleManager;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.mapper.mapping.SearchMappingCommonBuilding;
import org.infinispan.query.stats.impl.LocalIndexStatistics;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.PersistenceContextInitializerImpl;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;
import org.infinispan.server.core.query.ProtobufMetadataManager;
import org.infinispan.server.core.query.impl.DefaultQuerySerializer;
import org.infinispan.server.core.query.impl.GlobalContextInitializerImpl;
import org.infinispan.server.core.query.impl.JsonQuerySerializer;
import org.infinispan.server.core.query.impl.LazySearchMapping;
import org.infinispan.server.core.query.impl.ObjectRemoteQueryManager;
import org.infinispan.server.core.query.impl.ProtobufMetadataManagerImpl;
import org.infinispan.server.core.query.impl.ProtobufRemoteQueryManager;
import org.infinispan.server.core.query.impl.QuerySerializers;
import org.infinispan.server.core.query.impl.RemoteQueryAccessEngine;
import org.infinispan.server.core.query.impl.RemoteQueryManager;
import org.infinispan.tasks.query.RemoteQueryAccess;

@InfinispanModule(name="server-core", requiredModules={"core", "query"}, optionalModules={"jboss-marshalling"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        LifecycleManager queryModule;
        SerializationContextRegistry ctxRegistry = (SerializationContextRegistry)gcr.getComponent(SerializationContextRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new PersistenceContextInitializerImpl());
        ClassAllowList classAllowList = ((EmbeddedCacheManager)gcr.getComponent(EmbeddedCacheManager.class)).getClassAllowList();
        ClassLoader classLoader = globalConfiguration.classLoader();
        EncoderRegistry encoderRegistry = (EncoderRegistry)gcr.getComponent(EncoderRegistry.class);
        JsonTranscoder jsonTranscoder = new JsonTranscoder(classLoader, classAllowList);
        encoderRegistry.registerTranscoder((Transcoder)jsonTranscoder);
        this.registerXmlTranscoder(encoderRegistry, classLoader, classAllowList);
        if (encoderRegistry.isConversionSupported(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            Transcoder jbossMarshallingTranscoder = encoderRegistry.getTranscoder(MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JBOSS_MARSHALLING);
            encoderRegistry.registerTranscoder((Transcoder)new TwoStepTranscoder(jbossMarshallingTranscoder, (Transcoder)jsonTranscoder));
        }
        if ((queryModule = (LifecycleManager)gcr.getModuleLifecycle(LifecycleManager.class)) != null) {
            queryModule.enableRemoteQuery();
        }
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, (SerializationContextInitializer)new org.infinispan.server.core.query.impl.persistence.PersistenceContextInitializerImpl());
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, (SerializationContextInitializer)org.infinispan.query.remote.client.impl.GlobalContextInitializerImpl.INSTANCE);
        ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.GLOBAL, GlobalContextInitializerImpl.INSTANCE);
        this.initProtobufMetadataManager(bcr);
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        BasicComponentRegistry bcr = (BasicComponentRegistry)gcr.getComponent(BasicComponentRegistry.class);
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)bcr.getComponent(ProtobufMetadataManager.class).running();
        protobufMetadataManager.getCache();
        GlobalConfiguration globalCfg = gcr.getGlobalConfiguration();
        if (globalCfg.jmx().enabled()) {
            this.registerProtobufMetadataManagerMBean(protobufMetadataManager, globalCfg, bcr);
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        InternalCacheRegistry icr;
        BasicComponentRegistry gcr = (BasicComponentRegistry)cr.getGlobalComponentRegistry().getComponent(BasicComponentRegistry.class);
        LocalQueryStatistics queryStatistics = (LocalQueryStatistics)cr.getComponent(LocalQueryStatistics.class);
        if ("___protobuf_metadata".equals(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addProtobufMetadataManagerInterceptor((BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class));
        }
        if (!(icr = (InternalCacheRegistry)gcr.getComponent(InternalCacheRegistry.class).running()).isInternalCache(cacheName)) {
            ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)gcr.getComponent(ProtobufMetadataManager.class).running();
            protobufMetadataManager.addCacheDependency(cacheName);
            SerializationContext serCtx = protobufMetadataManager.getSerializationContext();
            SearchMappingCommonBuilding commonBuilding = (SearchMappingCommonBuilding)cr.getComponent(SearchMappingCommonBuilding.class);
            SearchMapping searchMapping = (SearchMapping)cr.getComponent(SearchMapping.class);
            if (commonBuilding != null && searchMapping == null) {
                AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache().withStorageMediaType();
                EntityLoaderFactory entityLoader = new EntityLoaderFactory(cache, queryStatistics);
                QueryCache queryCache = (QueryCache)cr.getGlobalComponentRegistry().getComponent(QueryCache.class);
                searchMapping = new LazySearchMapping(commonBuilding, entityLoader, serCtx, cache, protobufMetadataManager, queryCache);
                cr.registerComponent((Object)searchMapping, SearchMapping.class);
                BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
                bcr.replaceComponent(IndexStatistics.class.getName(), (Object)new LocalIndexStatistics(), true);
                bcr.rewire();
            }
            RemoteQueryManager remoteQueryManager = this.buildQueryManager(cfg, serCtx, cr, searchMapping);
            cr.registerComponent((Object)remoteQueryManager, RemoteQueryManager.class);
            cr.registerComponent((Object)new RemoteQueryAccessEngine(), RemoteQueryAccess.class);
        }
    }

    private void registerXmlTranscoder(EncoderRegistry encoderRegistry, ClassLoader classLoader, ClassAllowList classAllowList) {
        encoderRegistry.registerTranscoder((Transcoder)new XMLTranscoder(classLoader, classAllowList));
    }

    private void initProtobufMetadataManager(BasicComponentRegistry bcr) {
        ProtobufMetadataManagerImpl protobufMetadataManager = new ProtobufMetadataManagerImpl();
        bcr.registerComponent(ProtobufMetadataManager.class, (Object)protobufMetadataManager, true).running();
    }

    private void registerProtobufMetadataManagerMBean(ProtobufMetadataManagerImpl protobufMetadataManager, GlobalConfiguration globalConfig, BasicComponentRegistry bcr) {
        CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)bcr.getComponent(CacheManagerJmxRegistration.class).running();
        try {
            jmxRegistration.registerMBean((Object)protobufMetadataManager, this.getRemoteQueryGroupName(globalConfig));
        }
        catch (Exception e) {
            throw new CacheException("Unable to register ProtobufMetadataManager MBean", (Throwable)e);
        }
    }

    private String getRemoteQueryGroupName(GlobalConfiguration globalConfig) {
        return "type=RemoteQuery,name=" + ObjectName.quote(globalConfig.cacheManagerName());
    }

    private RemoteQueryManager buildQueryManager(Configuration cfg, SerializationContext ctx, ComponentRegistry cr, SearchMapping searchMapping) {
        boolean isObjectStorage;
        ContentTypeConfiguration valueEncoding = cfg.encoding().valueDataType();
        MediaType valueStorageMediaType = valueEncoding.mediaType();
        AdvancedCache cache = ((Cache)cr.getComponent(Cache.class)).getAdvancedCache();
        MediaType storageMediaType = cache.getValueDataConversion().getStorageMediaType();
        QuerySerializers querySerializers = this.buildQuerySerializers(cr, storageMediaType);
        boolean bl = isObjectStorage = valueStorageMediaType != null && valueStorageMediaType.match(MediaType.APPLICATION_OBJECT);
        if (isObjectStorage) {
            return new ObjectRemoteQueryManager(cache, cr, querySerializers);
        }
        return new ProtobufRemoteQueryManager(cache, cr, ctx, querySerializers, searchMapping);
    }

    private QuerySerializers buildQuerySerializers(ComponentRegistry cr, MediaType storageMediaType) {
        EncoderRegistry encoderRegistry = (EncoderRegistry)cr.getGlobalComponentRegistry().getComponent(EncoderRegistry.class);
        QuerySerializers querySerializers = new QuerySerializers();
        DefaultQuerySerializer defaultQuerySerializer = new DefaultQuerySerializer(encoderRegistry);
        querySerializers.addSerializer(MediaType.MATCH_ALL, defaultQuerySerializer);
        if (encoderRegistry.isConversionSupported(storageMediaType, MediaType.APPLICATION_JSON)) {
            Transcoder jsonStorage = encoderRegistry.getTranscoder(MediaType.APPLICATION_JSON, storageMediaType);
            querySerializers.addSerializer(MediaType.APPLICATION_JSON, new JsonQuerySerializer(storageMediaType, jsonStorage));
        }
        return querySerializers;
    }
}

