/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.telemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.global.GlobalTracingConfiguration;
import org.infinispan.configuration.global.TracingExporterProtocol;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.server.core.telemetry.OpenTelemetryService;
import org.infinispan.server.core.telemetry.inmemory.InMemoryTelemetryService;
import org.infinispan.server.core.telemetry.jfr.JfrSpanProcessor;
import org.infinispan.telemetry.InfinispanTelemetry;
import org.infinispan.telemetry.impl.DisabledInfinispanTelemetry;
import org.infinispan.util.logging.Log;
import org.jboss.logging.Logger;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={InfinispanTelemetry.class})
public class TelemetryServiceFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    public static final String IN_MEMORY_COLLECTOR_ENDPOINT = "file://in-memory-local-process";
    private static final org.infinispan.commons.logging.Log log = (org.infinispan.commons.logging.Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), org.infinispan.commons.logging.Log.class, (String)"org.infinispan.SERVER");

    public Object construct(String componentName) {
        if (!componentName.equals(InfinispanTelemetry.class.getName())) {
            throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
        }
        GlobalTracingConfiguration tracing = this.globalConfiguration.tracing();
        if (!tracing.enabled()) {
            return new DisabledInfinispanTelemetry();
        }
        if (IN_MEMORY_COLLECTOR_ENDPOINT.equals(tracing.collectorEndpoint())) {
            return new OpenTelemetryService(InMemoryTelemetryService.instance().openTelemetry());
        }
        try {
            OpenTelemetrySdk openTelemetry = AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> this.autoConfigureOpenTelemetryProperties(tracing)).addTracerProviderCustomizer((builder, ignore) -> this.configureTracerProvider((SdkTracerProviderBuilder)builder, tracing)).build().getOpenTelemetrySdk();
            log.telemetryLoaded((Object)openTelemetry);
            return new OpenTelemetryService((OpenTelemetry)openTelemetry);
        }
        catch (Throwable e) {
            log.errorOnLoadingTelemetry(e);
            return new DisabledInfinispanTelemetry();
        }
    }

    private Map<String, String> autoConfigureOpenTelemetryProperties(GlobalTracingConfiguration tracing) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("otel.metrics.exporter", "none");
        result.put("otel.logs.exporter", "none");
        result.put("otel.exporter.otlp.protocol", "http/protobuf");
        result.put("otel.service.name", tracing.serviceName());
        switch (tracing.exporterProtocol()) {
            case OTLP: {
                result.put("otel.traces.exporter", TracingExporterProtocol.OTLP.name().toLowerCase());
                result.put("otel.exporter.otlp.endpoint", tracing.collectorEndpoint());
                break;
            }
            case JAEGER: {
                result.put("otel.traces.exporter", TracingExporterProtocol.JAEGER.name().toLowerCase());
                result.put("otel.exporter.jaeger.endpoint", tracing.collectorEndpoint());
                break;
            }
            case ZIPKIN: {
                result.put("otel.traces.exporter", TracingExporterProtocol.ZIPKIN.name().toLowerCase());
                result.put("otel.exporter.zipkin.endpoint", tracing.collectorEndpoint());
                break;
            }
            case PROMETHEUS: {
                try {
                    URL url = new URL(tracing.collectorEndpoint());
                    result.put("otel.traces.exporter", TracingExporterProtocol.PROMETHEUS.name().toLowerCase());
                    result.put("otel.exporter.prometheus.host", url.getHost());
                    result.put("otel.exporter.prometheus.port", "" + url.getPort());
                    break;
                }
                catch (MalformedURLException e) {
                    throw log.errorOnParsingPrometheusURLForTracing((Throwable)e);
                }
            }
            case JFR: {
                result.put("otel.traces.exporter", "none");
                result.put("otel.exporter.otlp.protocol", "none");
            }
        }
        return result;
    }

    private SdkTracerProviderBuilder configureTracerProvider(SdkTracerProviderBuilder builder, GlobalTracingConfiguration configuration) {
        if (configuration.exporterProtocol() == TracingExporterProtocol.JFR) {
            builder.addSpanProcessor((SpanProcessor)new JfrSpanProcessor());
        }
        return builder;
    }
}

