/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.Security;
import org.infinispan.security.impl.SecureCacheImpl;
import org.infinispan.server.core.query.impl.GetSerializationContextAction;
import org.infinispan.server.core.query.impl.RemoteQueryManager;

final class SecurityActions {
    SecurityActions() {
    }

    static RemoteQueryManager getRemoteQueryManager(AdvancedCache<?, ?> cache) {
        return (RemoteQueryManager)org.infinispan.security.actions.SecurityActions.getCacheComponentRegistry(cache).getComponent(RemoteQueryManager.class);
    }

    static AuthorizationManager getCacheAuthorizationManager(AdvancedCache<?, ?> cache) {
        return (AuthorizationManager)Security.doPrivileged(() -> cache.getAuthorizationManager());
    }

    static <K, V> Cache<K, V> getUnwrappedCache(EmbeddedCacheManager cacheManager, String cacheName) {
        return (Cache)Security.doPrivileged(() -> {
            Cache cache = cacheManager.getCache(cacheName);
            if (cache instanceof SecureCacheImpl) {
                return ((SecureCacheImpl)cache).getDelegate();
            }
            return cache;
        });
    }

    static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        return (SerializationContext)Security.doPrivileged((Supplier)new GetSerializationContextAction(cacheManager));
    }
}

