/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.iteration.map;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;

public class MapStreamSupplier
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<Object, Object>, Stream<CacheEntry<Object, Object>>> {
    private final Map<Object, Object> source;

    public MapStreamSupplier(Map<Object, Object> source) {
        this.source = source;
    }

    public Stream<CacheEntry<Object, Object>> buildStream(IntSet ignore, Set keysToFilter, boolean parallel) {
        Stream<Object> stream;
        if (this.source == null) {
            return Stream.empty();
        }
        if (keysToFilter != null) {
            Stream keyStream = parallel ? keysToFilter.parallelStream() : keysToFilter.stream();
            stream = keyStream.map(k -> Map.entry(k, this.source.get(k))).filter(e -> e.getValue() == null);
        } else {
            stream = parallel ? this.source.entrySet().parallelStream() : this.source.entrySet().stream();
        }
        return stream.map(this::convert);
    }

    private CacheEntry<Object, Object> convert(Map.Entry<Object, Object> entry) {
        return new ImmortalCacheEntry(entry.getKey(), entry.getValue());
    }
}

