/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    CACHE,
    HOST,
    IDLE_TIMEOUT,
    IGNORED_CACHES,
    IO_THREADS,
    MAX_CONTENT_LENGTH,
    MECHANISMS,
    NAME,
    POLICY,
    PORT,
    QOP,
    RECEIVE_BUFFER_SIZE,
    REQUIRE_SSL_CLIENT_AUTH,
    SECURITY_REALM,
    SEND_BUFFER_SIZE,
    SERVER_NAME,
    SERVER_PRINCIPAL,
    SOCKET_BINDING,
    START_TRANSPORT,
    STRENGTH,
    TCP_KEEPALIVE,
    TCP_NODELAY,
    VALUE,
    ZERO_CAPACITY_NODE;

    public static final String DEFAULT_MAX_CONTENT_LENGTH = "10MB";
    private static final Map<String, Attribute> ATTRIBUTES;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    private Attribute() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public static Attribute forName(String localName) {
        Attribute attribute = ATTRIBUTES.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.name;
            if (name == null) continue;
            map.put(name, attribute);
        }
        ATTRIBUTES = map;
    }
}

