/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.api.Experimental;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.QueryConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.query.impl.BaseRemoteQueryManager;
import org.infinispan.server.core.query.impl.RemoteQueryManager;
import org.infinispan.server.core.query.impl.access.RemoteQueryAccessQuery;
import org.infinispan.server.core.query.impl.logging.Log;
import org.infinispan.tasks.query.RemoteQueryAccess;

@Scope(value=Scopes.NAMED_CACHE)
@Experimental
public class RemoteQueryAccessEngine
implements RemoteQueryAccess {
    private static final Log log = (Log)LogFactory.getLog(RemoteQueryAccessEngine.class, Log.class);
    @Inject
    RemoteQueryManager remoteQueryManager;
    @Inject
    SerializationContextRegistry serializationContextRegistry;
    @Inject
    AdvancedCache<?, ?> cache;
    private int defaultMaxResults;
    private int defaultHitCountAccuracy;

    @Start
    public void start() {
        Configuration configuration = SecurityActions.getCacheConfiguration(this.cache);
        QueryConfiguration query = configuration.query();
        this.defaultMaxResults = query.defaultMaxResults();
        this.defaultHitCountAccuracy = query.hitCountAccuracy();
    }

    public <T> Query<T> query(String query) {
        return new RemoteQueryAccessQuery(this, query);
    }

    public int defaultMaxResult() {
        return this.defaultMaxResults;
    }

    public int defaultHitCountAccuracy() {
        return this.defaultHitCountAccuracy;
    }

    public QueryResult<?> executeQuery(String queryString, Map<String, Object> namedParametersMap, Integer offset, Integer maxResults, Integer hitCountAccuracy, boolean isLocal) {
        BaseRemoteQueryManager.QueryResultWithProjection result = this.remoteQueryManager.localQuery(queryString, namedParametersMap, offset, maxResults, hitCountAccuracy, this.cache, isLocal);
        QueryResult<Object> queryResult = result.queryResult();
        String[] projection = result.projection();
        List<Object> results = RemoteQueryAccessEngine.extractResults(this.serializationContextRegistry.getUserCtx(), projection != null, queryResult.list());
        return new QueryResultImpl(queryResult.count(), results);
    }

    private static List<Object> extractResults(ImmutableSerializationContext serializationContext, boolean projection, List<Object> results) {
        if (serializationContext == null || results.isEmpty()) {
            return results;
        }
        ArrayList<Object> unwrappedResults = new ArrayList<Object>(results.size());
        if (projection) {
            for (Object result : results) {
                Object[] objects = (Object[])result;
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = RemoteQueryAccessEngine.unmarshall(serializationContext, objects[i]);
                }
                unwrappedResults.add(objects);
            }
        } else {
            for (Object result : results) {
                unwrappedResults.add(RemoteQueryAccessEngine.unmarshall(serializationContext, result));
            }
        }
        return unwrappedResults;
    }

    private static Object unmarshall(ImmutableSerializationContext context, Object value) {
        try {
            Object object;
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                object = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)context, (byte[])bytes);
            } else {
                object = value;
            }
            return object;
        }
        catch (IOException e) {
            log.errorUnmarshallingProtobufEntity(e);
            return value;
        }
    }
}

