/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.impl.EntityLoaderFactory;
import org.infinispan.query.mapper.mapping.SearchIndexedEntity;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.mapper.mapping.SearchMappingBuilder;
import org.infinispan.query.mapper.mapping.SearchMappingCommonBuilding;
import org.infinispan.query.mapper.mapping.impl.InfinispanMapping;
import org.infinispan.query.mapper.mapping.metamodel.IndexMetamodel;
import org.infinispan.query.mapper.scope.SearchScope;
import org.infinispan.query.mapper.session.SearchSession;
import org.infinispan.query.mapper.work.SearchIndexer;
import org.infinispan.server.core.query.impl.ProtobufMetadataManagerImpl;
import org.infinispan.server.core.query.impl.logging.Log;
import org.infinispan.server.core.query.impl.mapping.SerializationContextSearchMapping;
import org.infinispan.server.core.query.impl.util.LazyRef;

public class LazySearchMapping
implements SearchMapping {
    private static final Log log = (Log)LogFactory.getLog(LazySearchMapping.class, Log.class);
    private final Cache<?, ?> cache;
    private final ProtobufMetadataManagerImpl protobufMetadataManager;
    private final SearchMappingCommonBuilding commonBuilding;
    private final EntityLoaderFactory<?> entityLoader;
    private final SerializationContext serCtx;
    private final QueryCache queryCache;
    private LazyRef<SearchMapping> searchMappingRef = new LazyRef<SearchMapping>(this::createMapping);
    private final StampedLock stampedLock = new StampedLock();
    private volatile boolean restarting = false;

    public LazySearchMapping(SearchMappingCommonBuilding commonBuilding, EntityLoaderFactory<?> entityLoader, SerializationContext serCtx, AdvancedCache<?, ?> cache, ProtobufMetadataManagerImpl protobufMetadataManager, QueryCache queryCache) {
        this.commonBuilding = commonBuilding;
        this.entityLoader = entityLoader;
        this.serCtx = serCtx;
        this.cache = cache;
        this.protobufMetadataManager = protobufMetadataManager;
        this.queryCache = queryCache;
    }

    public <E> SearchScope<E> scope(Collection<? extends Class<? extends E>> types) {
        return this.mapping().scope(types);
    }

    public SearchScope<?> scopeAll() {
        return this.mapping().scopeAll();
    }

    public Optional<SearchScope<?>> findScopeAll() {
        return this.findMapping().map(SearchMapping::scopeAll);
    }

    public FailureHandler getFailureHandler() {
        return this.mapping().getFailureHandler();
    }

    public void start() {
    }

    public void close() {
        this.findMapping().ifPresent(SearchMapping::close);
    }

    public boolean isClose() {
        return this.mapping().isClose();
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public SearchSession getMappingSession() {
        return this.mapping().getMappingSession();
    }

    public SearchIndexer getSearchIndexer() {
        return this.mapping().getSearchIndexer();
    }

    public SearchIndexedEntity indexedEntity(Class<?> entityType) {
        return this.mapping().indexedEntity(entityType);
    }

    public SearchIndexedEntity indexedEntity(String entityName) {
        return this.mapping().indexedEntity(entityName);
    }

    public Collection<? extends SearchIndexedEntity> allIndexedEntities() {
        return this.mapping().allIndexedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends SearchIndexedEntity> indexedEntitiesForStatistics() {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp == 0L) {
            return Collections.emptySet();
        }
        try {
            if (!this.searchMappingRef.available()) {
                Set set = Collections.emptySet();
                return set;
            }
            Collection<? extends SearchIndexedEntity> collection = this.allIndexedEntities();
            return collection;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    public Set<String> allIndexedEntityNames() {
        return this.mapping().allIndexedEntityNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Class<?>> allIndexedEntityJavaClasses() {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp == 0L) {
            return Collections.singleton(byte[].class);
        }
        try {
            if (!this.searchMappingRef.available()) {
                Set<Class<?>> set = Collections.singleton(byte[].class);
                return set;
            }
            Set set = this.mapping().allIndexedEntityJavaClasses();
            return set;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    public boolean typeIsIndexed(Object value) {
        return this.mapping().typeIsIndexed(value);
    }

    public boolean typeIsIndexed(Object value, Collection<Class<?>> restricted) {
        return this.mapping().typeIsIndexed(value, restricted);
    }

    public Map<String, IndexMetamodel> metamodel() {
        return this.mapping().metamodel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int genericIndexingFailures() {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp == 0L) {
            return -1;
        }
        try {
            if (!this.searchMappingRef.available()) {
                int n = -1;
                return n;
            }
            int n = this.mapping().genericIndexingFailures();
            return n;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int entityIndexingFailures() {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp == 0L) {
            return -1;
        }
        try {
            if (!this.searchMappingRef.available()) {
                int n = -1;
                return n;
            }
            int n = this.mapping().entityIndexingFailures();
            return n;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    public void reload() {
        long stamp = this.stampedLock.writeLock();
        this.queryCache.clear(this.cache.getName());
        try {
            this.searchMappingRef.get().close();
            this.searchMappingRef = new LazyRef<SearchMapping>(this::createMapping);
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        long stamp = this.stampedLock.writeLock();
        try {
            this.restarting = true;
            InfinispanMapping mapping = (InfinispanMapping)this.searchMappingRef.get();
            this.searchMappingRef = new LazyRef<SearchMapping>(() -> this.createMapping(Optional.of(mapping.getIntegration())));
            this.searchMappingRef.get();
        }
        finally {
            this.restarting = false;
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchMapping mapping() {
        long stamp = this.stampedLock.tryOptimisticRead();
        SearchMapping searchMapping = this.searchMappingRef.get();
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.readLock();
            try {
                searchMapping = this.searchMappingRef.get();
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        return searchMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SearchMapping> findMapping() {
        long stamp = this.stampedLock.tryOptimisticRead();
        SearchMapping mapping = null;
        if (this.searchMappingRef.available()) {
            mapping = this.searchMappingRef.get();
        }
        if (!this.stampedLock.validate(stamp)) {
            stamp = this.stampedLock.readLock();
            try {
                if (this.searchMappingRef.available()) {
                    mapping = this.searchMappingRef.get();
                }
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        return Optional.ofNullable(mapping);
    }

    private SearchMapping createMapping() {
        return this.createMapping(Optional.empty());
    }

    private SearchMapping createMapping(Optional<SearchIntegration> previousIntegration) {
        IndexingConfiguration indexingConfiguration = this.cache.getCacheConfiguration().indexing();
        Set indexedEntityTypes = indexingConfiguration.indexedEntityTypes();
        DataConversion valueDataConversion = this.cache.getAdvancedCache().getValueDataConversion();
        SearchMapping searchMapping = null;
        if (this.commonBuilding != null) {
            SearchMappingBuilder builder = SerializationContextSearchMapping.createBuilder(this.commonBuilding, this.entityLoader, indexedEntityTypes, this.serCtx);
            SearchMapping searchMapping2 = searchMapping = builder != null ? builder.build(previousIntegration) : null;
        }
        if (indexingConfiguration.enabled() && valueDataConversion.getStorageMediaType().match(MediaType.APPLICATION_PROTOSTREAM)) {
            Set<String> knownTypes = this.protobufMetadataManager.getKnownTypes();
            for (String typeName : indexedEntityTypes) {
                if (!knownTypes.contains(typeName)) {
                    if (searchMapping != null) {
                        searchMapping.close();
                    }
                    throw log.unknownType(typeName);
                }
                if (searchMapping != null && searchMapping.indexedEntity(typeName) != null) continue;
                if (searchMapping != null) {
                    searchMapping.close();
                }
                throw log.typeNotIndexed(typeName);
            }
        }
        if (searchMapping != null) {
            searchMapping.start();
        }
        return searchMapping;
    }
}

