/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion.deserializer;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.server.core.dataconversion.deserializer.SArray;
import org.infinispan.server.core.dataconversion.deserializer.SBlockData;
import org.infinispan.server.core.dataconversion.deserializer.SEntity;
import org.infinispan.server.core.dataconversion.deserializer.SObject;
import org.infinispan.server.core.dataconversion.deserializer.SPrim;
import org.infinispan.server.core.dataconversion.deserializer.SString;

public class Deserializer {
    private static final SEntity END = new SString("END");
    private final PrimitiveClassDescFactory primitiveClassDescFactory = new PrimitiveClassDescFactory();
    private final DataInputStream din;
    private final List<SEntity> handles = new ArrayList<SEntity>();
    private final Map<String, ClassDesc> classDescriptions = new HashMap<String, ClassDesc>();

    public Deserializer(InputStream in, boolean header) throws IOException {
        this.din = new DataInputStream(in);
        if (header && (this.din.readShort() != -21267 || this.din.readShort() != 5)) {
            throw new StreamCorruptedException("Bad stream header");
        }
    }

    public SEntity readObject() throws IOException {
        SEntity entity = this.readObjectOrEnd();
        if (entity == END) {
            throw new StreamCorruptedException("Unexpected end-block-data");
        }
        return entity;
    }

    private SString readString() throws IOException {
        return (SString)this.readObject();
    }

    private SEntity readObjectOrEnd() throws IOException {
        byte code;
        block16: while (true) {
            code = this.din.readByte();
            switch (code) {
                case 115: {
                    return this.newObject();
                }
                case 118: {
                    return this.newClass();
                }
                case 117: {
                    return this.newArray();
                }
                case 116: {
                    return this.newString();
                }
                case 124: {
                    return this.newLongString();
                }
                case 126: {
                    return this.newEnum();
                }
                case 114: 
                case 125: {
                    this.classDesc(code);
                    continue block16;
                }
                case 113: {
                    return this.prevObject();
                }
                case 112: {
                    return null;
                }
                case 123: {
                    this.exception();
                    continue block16;
                }
                case 121: {
                    this.reset();
                    continue block16;
                }
                case 119: {
                    return this.blockDataShort();
                }
                case 122: {
                    return this.blockDataLong();
                }
                case 120: {
                    return END;
                }
            }
            break;
        }
        throw new StreamCorruptedException("Bad type code: " + code);
    }

    private SEntity newObject() throws IOException {
        ObjectClassDesc desc = this.classDesc();
        SObject t = new SObject(desc.getType());
        this.newHandle(t);
        for (ObjectClassDesc cd : desc.getHierarchy()) {
            this.classData(t, cd);
        }
        return t;
    }

    private void classData(SObject t, ObjectClassDesc cd) throws IOException {
        int flags = cd.getFlags();
        if ((flags & 2) != 0) {
            for (FieldDesc fieldDesc : cd.getFields()) {
                t.setField(fieldDesc.getName(), fieldDesc.read());
            }
            if ((flags & 1) != 0) {
                this.objectAnnotation(t);
            }
        } else if ((flags & 4) != 0) {
            if ((flags & 8) == 0) {
                throw new IOException("Can't handle externalContents");
            }
            this.objectAnnotation(t);
        }
    }

    private void objectAnnotation(SObject t) throws IOException {
        while (this.readObjectOrEnd() != END) {
        }
    }

    private ClassDesc newClass() throws IOException {
        ObjectClassDesc desc = this.classDesc();
        this.newHandle(desc);
        return desc;
    }

    private ObjectClassDesc classDesc() throws IOException {
        byte code = this.din.readByte();
        return this.classDesc(code);
    }

    private ObjectClassDesc classDesc(int code) throws IOException {
        return this.classDesc0(code);
    }

    private ObjectClassDesc classDesc0(int code) throws IOException {
        switch (code) {
            case 114: {
                return this.newPlainClassDesc();
            }
            case 125: {
                return this.newProxyClassDesc();
            }
            case 112: {
                return null;
            }
            case 113: {
                return (ObjectClassDesc)this.prevObject();
            }
        }
        throw new StreamCorruptedException("Bad class descriptor");
    }

    private ObjectClassDesc newPlainClassDesc() throws IOException {
        String className = this.din.readUTF();
        long serialVersionUID = this.din.readLong();
        byte flags = this.din.readByte();
        ObjectClassDesc desc = className.startsWith("[") ? this.getArrayClassDesc(className, flags, serialVersionUID) : this.getObjectClassDesc(className, flags, serialVersionUID);
        this.newHandle(desc);
        int nfields = this.din.readShort();
        FieldDesc[] fields = new FieldDesc[nfields];
        for (int i = 0; i < nfields; ++i) {
            fields[i] = this.fieldDesc();
        }
        desc.setFields(fields);
        this.classAnnotation(desc);
        ObjectClassDesc superDesc = this.classDesc();
        desc.setSuperClassDesc(superDesc);
        return desc;
    }

    private ObjectClassDesc getObjectClassDesc(String className, int flags, Long serialVersionUID) {
        ObjectClassDesc desc = (ObjectClassDesc)this.classDescriptions.get(className);
        if (desc != null) {
            if (desc.getSerialVersionUID() == null) {
                desc.setSerialVersionUID(serialVersionUID);
            }
            if (!desc.getName().equals(className) || desc.getFlags() != flags) {
                throw new IllegalStateException("name/flags/serialVersionUID don't match");
            }
            return desc;
        }
        desc = new ObjectClassDesc(className, flags, serialVersionUID);
        this.classDescriptions.put(desc.getName(), desc);
        return desc;
    }

    private ArrayClassDesc getArrayClassDesc(String className, int flags, Long serialVersionUID) throws IOException {
        ArrayClassDesc desc = (ArrayClassDesc)this.classDescriptions.get(className);
        if (desc != null) {
            if (desc.getSerialVersionUID() == null) {
                desc.setSerialVersionUID(serialVersionUID);
            }
            if (!desc.getName().equals(className) || desc.getFlags() != flags) {
                throw new IllegalStateException("name/flags/serialVersionUID don't match");
            }
            return desc;
        }
        desc = new ArrayClassDesc(className, flags, (long)serialVersionUID);
        this.classDescriptions.put(desc.getName(), desc);
        return desc;
    }

    private ObjectClassDesc newProxyClassDesc() throws IOException {
        ObjectClassDesc desc = new ObjectClassDesc("<Proxy>", 2, 1L);
        this.newHandle(desc);
        int count = this.din.readInt();
        for (int i = 0; i < count; ++i) {
            this.din.readUTF();
        }
        this.classAnnotation(desc);
        ObjectClassDesc superDesc = this.classDesc();
        desc.setSuperClassDesc(superDesc);
        return desc;
    }

    private void classAnnotation(ClassDesc desc) throws IOException {
        while (this.readObjectOrEnd() != END) {
        }
    }

    private FieldDesc fieldDesc() throws IOException {
        FieldDesc desc;
        char c = (char)this.din.readByte();
        boolean primitive = switch (c) {
            case 'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z' -> true;
            case 'L', '[' -> false;
            default -> throw new StreamCorruptedException("Bad field type " + c);
        };
        String name = this.din.readUTF();
        if (primitive) {
            desc = new PrimitiveFieldDesc(name, c);
        } else {
            String className = this.readString().getValue();
            if (className.startsWith("L")) {
                className = className.substring(1, className.length() - 1);
            }
            className = className.replaceAll("/", ".");
            desc = new ReferenceFieldDesc(name, className);
        }
        return desc;
    }

    private SArray newArray() throws IOException {
        ArrayClassDesc classDesc = (ArrayClassDesc)this.classDesc();
        int size = this.din.readInt();
        SArray array = new SArray(classDesc.getType(), size);
        this.newHandle(array);
        ClassDesc componentClassDesc = classDesc.getComponentClassDesc();
        for (int i = 0; i < size; ++i) {
            array.set(i, componentClassDesc.read());
        }
        return array;
    }

    private SString newString() throws IOException {
        SString s = new SString(this.din.readUTF());
        this.newHandle(s);
        return s;
    }

    private SString newLongString() throws IOException {
        int slice;
        StringBuilder sb = new StringBuilder();
        for (long len = this.din.readLong(); len > 0L; len -= (long)slice) {
            slice = (int)Math.min(len, 65535L);
            byte[] blen = new byte[]{(byte)(slice >> 8), (byte)slice};
            ByteArrayInputStream lenis = new ByteArrayInputStream(blen);
            SequenceInputStream seqis = new SequenceInputStream(lenis, this.din);
            DataInputStream ddin = new DataInputStream(seqis);
            String s = ddin.readUTF();
            assert (s.length() == slice);
            sb.append(s);
        }
        return new SString(sb.toString());
    }

    private SObject newEnum() throws IOException {
        ObjectClassDesc classDesc = this.classDesc();
        SObject enumConst = new SObject(classDesc.getType());
        this.newHandle(enumConst);
        SString constName = this.readString();
        classDesc.getEnumValues().add(constName.getValue());
        enumConst.setField("<name>", constName);
        return enumConst;
    }

    private void exception() throws IOException {
        this.reset();
        IOException exc = new IOException(this.readObject().toString());
        this.reset();
        throw new WriteAbortedException("Writing aborted", exc);
    }

    private SBlockData blockDataShort() throws IOException {
        int len = this.din.readUnsignedByte();
        return this.blockData(len);
    }

    private SBlockData blockDataLong() throws IOException {
        int len = this.din.readInt();
        return this.blockData(len);
    }

    private SBlockData blockData(int len) throws IOException {
        byte[] data = new byte[len];
        this.din.readFully(data);
        return new SBlockData(data);
    }

    private void newHandle(SEntity o) {
        this.handles.add(o);
    }

    private SEntity prevObject() throws IOException {
        int h = this.din.readInt();
        int i = h - 0x7E0000;
        if (i < 0 || i > this.handles.size()) {
            throw new StreamCorruptedException("Bad handle: " + h);
        }
        return this.handles.get(i);
    }

    private void reset() {
        this.handles.clear();
    }

    class PrimitiveClassDescFactory {
        private final Map<Character, PrimitiveClassDesc> DESCRIPTORS = new HashMap<Character, PrimitiveClassDesc>();

        PrimitiveClassDescFactory() {
            String primitives = "BByte CChar DDouble FFloat IInt JLong SShort ZBoolean";
            for (String prim : primitives.split(" ")) {
                Class<?> componentClass;
                Method readMethod;
                char typeCode = prim.charAt(0);
                String readWhat = prim.substring(1);
                try {
                    readMethod = DataInputStream.class.getMethod("read" + readWhat, new Class[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("No read method for " + readWhat, e);
                }
                try {
                    Class<?> arrayClass = Class.forName("[" + typeCode);
                    componentClass = arrayClass.getComponentType();
                }
                catch (Exception e) {
                    throw new RuntimeException("No array class for " + typeCode, e);
                }
                PrimitiveClassDesc desc = new PrimitiveClassDesc(typeCode, readMethod, componentClass);
                this.DESCRIPTORS.put(Character.valueOf(typeCode), desc);
            }
        }

        PrimitiveClassDesc forTypeCode(char c) throws IOException {
            PrimitiveClassDesc desc = this.DESCRIPTORS.get(Character.valueOf(c));
            if (desc == null) {
                throw new StreamCorruptedException("Bad type code " + c);
            }
            return desc;
        }
    }

    public static abstract class ClassDesc
    extends SEntity {
        private final String name;

        ClassDesc(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public Json json() {
            throw new UnsupportedOperationException();
        }

        public abstract String toString();

        abstract SEntity read() throws IOException;

        abstract Class<?> arrayComponentClass();

        public String getName() {
            return this.name;
        }
    }

    public class ObjectClassDesc
    extends ClassDesc {
        private final int flags;
        private final List<ObjectClassDesc> hierarchy;
        private final Set<String> enumValues;
        private Long serialVersionUID;
        private FieldDesc[] fields;
        private ObjectClassDesc superClassDesc;

        ObjectClassDesc(String name, int flags, Long serialVersionUID) {
            super(name);
            this.hierarchy = new ArrayList<ObjectClassDesc>();
            this.enumValues = new HashSet<String>();
            this.fields = new FieldDesc[0];
            this.flags = flags;
            this.serialVersionUID = serialVersionUID;
        }

        public Long getSerialVersionUID() {
            return this.serialVersionUID;
        }

        public void setSerialVersionUID(Long serialVersionUID) {
            this.serialVersionUID = serialVersionUID;
        }

        @Override
        SEntity read() throws IOException {
            return Deserializer.this.readObject();
        }

        @Override
        Class<?> arrayComponentClass() {
            if (this.getType().equals("java.lang.String")) {
                return String.class;
            }
            return SEntity.class;
        }

        @Override
        public String toString() {
            return this.getType();
        }

        public FieldDesc[] getFields() {
            return this.fields;
        }

        public void setFields(FieldDesc[] fields) {
            this.fields = fields;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setSuperClassDesc(ObjectClassDesc superClassDesc) {
            this.superClassDesc = superClassDesc;
        }

        public List<ObjectClassDesc> getHierarchy() {
            if (this.hierarchy.isEmpty()) {
                if (this.superClassDesc != null) {
                    this.hierarchy.addAll(this.superClassDesc.getHierarchy());
                }
                this.hierarchy.add(this);
            }
            return this.hierarchy;
        }

        public Set<String> getEnumValues() {
            return this.enumValues;
        }
    }

    public static abstract class FieldDesc {
        private final String name;

        FieldDesc(String name) {
            this.name = name;
        }

        abstract SEntity read() throws IOException;

        public abstract String toString();

        public String getName() {
            return this.name;
        }

        public abstract String getTypeName();
    }

    public class ArrayClassDesc
    extends ObjectClassDesc {
        private final ClassDesc componentClassDesc;
        private final Class<?> arrayClass;

        ArrayClassDesc(String name, int flags, long serialVersionUID) throws IOException {
            super(name, flags, serialVersionUID);
            String componentName = name.substring(1);
            if (componentName.startsWith("[")) {
                this.componentClassDesc = Deserializer.this.getArrayClassDesc(componentName, flags, null);
            } else if (componentName.startsWith("L")) {
                componentName = componentName.substring(1, componentName.length() - 1);
                this.componentClassDesc = Deserializer.this.getObjectClassDesc(componentName, flags, null);
            } else {
                if (componentName.length() > 1) {
                    throw new StreamCorruptedException("Bad array type " + name);
                }
                char typeCode = componentName.charAt(0);
                this.componentClassDesc = Deserializer.this.primitiveClassDescFactory.forTypeCode(typeCode);
            }
            Class<?> componentClass = this.componentClassDesc.arrayComponentClass();
            this.arrayClass = Array.newInstance(componentClass, 0).getClass();
        }

        @Override
        Class<?> arrayComponentClass() {
            return this.arrayClass;
        }

        public ClassDesc getComponentClassDesc() {
            return this.componentClassDesc;
        }
    }

    public class PrimitiveFieldDesc
    extends FieldDesc {
        private final PrimitiveClassDesc classDesc;

        PrimitiveFieldDesc(String name, char type) throws IOException {
            super(name);
            this.classDesc = Deserializer.this.primitiveClassDescFactory.forTypeCode(type);
        }

        @Override
        SEntity read() throws IOException {
            return this.classDesc.read();
        }

        @Override
        public String toString() {
            return String.valueOf(this.classDesc) + " " + this.getName();
        }

        @Override
        public String getTypeName() {
            return this.classDesc.toString();
        }
    }

    public class ReferenceFieldDesc
    extends FieldDesc {
        private final String className;

        ReferenceFieldDesc(String name, String className) {
            super(name);
            this.className = className;
        }

        @Override
        SEntity read() throws IOException {
            return Deserializer.this.readObject();
        }

        @Override
        public String toString() {
            return this.className + " " + this.getName();
        }

        @Override
        public String getTypeName() {
            return this.className;
        }
    }

    public class PrimitiveClassDesc
    extends ClassDesc {
        private final Method readMethod;
        private final Class<?> componentClass;

        PrimitiveClassDesc(char typeCode, Method readMethod, Class<?> componentClass) {
            super(String.valueOf(typeCode));
            this.readMethod = readMethod;
            this.componentClass = componentClass;
        }

        @Override
        SEntity read() throws IOException {
            try {
                Object wrapped = this.readMethod.invoke((Object)Deserializer.this.din, new Object[0]);
                return new SPrim(wrapped);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Read method invoke failed", e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t.toString(), t);
            }
        }

        @Override
        Class<?> arrayComponentClass() {
            return this.componentClass;
        }

        @Override
        public String toString() {
            return this.componentClass.getName();
        }
    }
}

