/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl.indexing.search5;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.AnnotationParserException;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.server.core.query.impl.indexing.FieldMapping;
import org.infinispan.server.core.query.impl.indexing.IndexingKeyMetadata;
import org.infinispan.server.core.query.impl.indexing.IndexingMetadata;
import org.infinispan.server.core.query.impl.indexing.SpatialFieldMapping;
import org.infinispan.server.core.query.impl.indexing.infinispan.InfinispanMetadataCreator;
import org.infinispan.server.core.query.impl.logging.Log;

public final class Search5MetadataCreator
implements AnnotationMetadataCreator<IndexingMetadata, Descriptor> {
    private static final Log log = (Log)LogFactory.getLog(Search5MetadataCreator.class, Log.class);

    public IndexingMetadata create(Descriptor descriptor, AnnotationElement.Annotation annotation) {
        String v;
        Boolean enabled = (Boolean)annotation.getAttributeValue("enabled").getValue();
        String indexName = (String)annotation.getAttributeValue("index").getValue();
        if (indexName.isEmpty()) {
            indexName = null;
        }
        String entityAnalyzer = null;
        AnnotationElement.Annotation entityAnalyzerAnnotation = IndexingMetadata.findAnnotation(descriptor.getAnnotations(), "Analyzer");
        if (entityAnalyzerAnnotation != null && !(v = (String)entityAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
            entityAnalyzer = v;
        }
        Map<String, SpatialFieldMapping> spatialFields = Search5MetadataCreator.spatialFields(descriptor);
        Map<String, FieldMapping> fields = Search5MetadataCreator.fieldsMapping(descriptor, spatialFields);
        String keyEntity = (String)annotation.getAttributeValue("keyEntity").getValue();
        IndexingKeyMetadata indexingKeyMetadata = null;
        if (!keyEntity.isEmpty()) {
            String keyPropertyName = (String)annotation.getAttributeValue("keyPropertyName").getValue();
            if (fields.containsKey(keyPropertyName)) {
                throw log.keyPropertyNameAlreadyInUse(keyPropertyName);
            }
            Integer includeDepth = (Integer)annotation.getAttributeValue("keyIncludeDepth").getValue();
            indexingKeyMetadata = new IndexingKeyMetadata(keyPropertyName, keyEntity, includeDepth);
        }
        IndexingMetadata indexingMetadata = new IndexingMetadata(enabled, indexName, entityAnalyzer, fields, spatialFields, indexingKeyMetadata);
        if (log.isDebugEnabled()) {
            log.debugf("Descriptor name=%s indexingMetadata=%s", descriptor.getFullName(), indexingMetadata);
        }
        return indexingMetadata;
    }

    public static IndexingMetadata createForEmbeddedType(Descriptor descriptor) {
        Map<String, SpatialFieldMapping> spatialFields = Search5MetadataCreator.spatialFields(descriptor);
        Map<String, FieldMapping> fields = Search5MetadataCreator.fieldsMapping(descriptor, spatialFields);
        IndexingMetadata indexingMetadata = new IndexingMetadata(false, null, null, fields, spatialFields, null);
        if (log.isDebugEnabled()) {
            log.debugf("Descriptor name=%s indexingMetadata=%s", descriptor.getFullName(), indexingMetadata);
        }
        return indexingMetadata;
    }

    private static Map<String, FieldMapping> fieldsMapping(Descriptor descriptor, Map<String, SpatialFieldMapping> spatialFields) {
        HashMap<String, FieldMapping> fields = new HashMap<String, FieldMapping>(descriptor.getFields().size());
        for (FieldDescriptor fd : descriptor.getFields()) {
            FieldMapping existingFieldMapping;
            Map annotations = fd.getAnnotations();
            AnnotationElement.Annotation longitudeAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("Longitude");
            if (longitudeAnnotation != null) {
                Search5MetadataCreator.processLongitude(fd, longitudeAnnotation, spatialFields);
                continue;
            }
            AnnotationElement.Annotation latitudeAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get("Latitude");
            if (latitudeAnnotation != null) {
                Search5MetadataCreator.processLatitude(fd, latitudeAnnotation, spatialFields);
                continue;
            }
            String fieldName = fd.getName();
            if (spatialFields.containsKey(fieldName)) {
                throw new AnnotationParserException("The spatial index field '" + fieldName + "' clashes with the field declared by " + fd.getFullName());
            }
            FieldMapping fieldMapping = InfinispanMetadataCreator.fieldMapping(fd, annotations);
            if (fieldMapping != null) {
                FieldMapping existingFieldMapping2 = fields.put(fieldName, fieldMapping);
                if (existingFieldMapping2 == null) continue;
                throw new AnnotationParserException("The index field " + fieldName + " was already declared by field " + existingFieldMapping2.getFieldDescriptor().getFullName());
            }
            SpatialFieldMapping spatialFieldMapping = InfinispanMetadataCreator.geoField(fd, annotations);
            if (spatialFieldMapping != null) {
                spatialFields.put(spatialFieldMapping.fieldName(), spatialFieldMapping);
                continue;
            }
            fieldMapping = Search5MetadataCreator.search5FieldMapping(fd, annotations);
            if (fieldMapping == null || (existingFieldMapping = fields.put(fieldName, fieldMapping)) == null) continue;
            throw new AnnotationParserException("The index field " + fieldName + " was already declared by field " + existingFieldMapping.getFieldDescriptor().getFullName());
        }
        return fields;
    }

    private static Map<String, SpatialFieldMapping> spatialFields(Descriptor descriptor) {
        AnnotationElement.Annotation spatialsAnnotation;
        HashMap<String, SpatialFieldMapping> spatialFields = new HashMap<String, SpatialFieldMapping>();
        AnnotationElement.Annotation spatialAnnotation = (AnnotationElement.Annotation)descriptor.getAnnotations().get("GeoPoint");
        if (spatialAnnotation != null) {
            SpatialFieldMapping spatial = InfinispanMetadataCreator.geoPoint(spatialAnnotation);
            spatialFields.put(spatial.fieldName(), spatial);
        }
        if ((spatialsAnnotation = (AnnotationElement.Annotation)descriptor.getAnnotations().get("GeoPoints")) != null) {
            for (AnnotationElement.Value v : ((AnnotationElement.Array)spatialsAnnotation.getDefaultAttributeValue()).getValues()) {
                SpatialFieldMapping spatial = InfinispanMetadataCreator.geoPoint((AnnotationElement.Annotation)v);
                spatialFields.put(spatial.fieldName(), spatial);
            }
        }
        return spatialFields;
    }

    private static FieldMapping search5FieldMapping(FieldDescriptor fd, Map<String, AnnotationElement.Annotation> annotations) {
        AnnotationElement.Annotation fieldLevelAnalyzerAnnotationAttribute;
        String fieldLevelAnalyzerAttribute;
        String v;
        String fieldLevelAnalyzer = null;
        AnnotationElement.Annotation fieldAnalyzerAnnotation = IndexingMetadata.findAnnotation(fd.getAnnotations(), "Analyzer");
        if (fieldAnalyzerAnnotation != null && !(v = (String)fieldAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
            fieldLevelAnalyzer = v;
        }
        boolean isSortable = IndexingMetadata.findAnnotation(fd.getAnnotations(), "SortableField") != null;
        AnnotationElement.Annotation fieldAnnotation = IndexingMetadata.findAnnotation(fd.getAnnotations(), "Field");
        if (fieldAnnotation == null) {
            return null;
        }
        String fieldName = fd.getName();
        String v2 = (String)fieldAnnotation.getAttributeValue("name").getValue();
        if (!v2.isEmpty()) {
            fieldName = v2;
        }
        AnnotationElement.Value indexAttribute = fieldAnnotation.getAttributeValue("index");
        boolean isIndexed = IndexingMetadata.attributeMatches(indexAttribute, "org.hibernate.search.annotations", "Index.YES", "YES");
        AnnotationElement.Value analyzeAttribute = fieldAnnotation.getAttributeValue("analyze");
        boolean isAnalyzed = IndexingMetadata.attributeMatches(analyzeAttribute, "org.hibernate.search.annotations", "Analyze.YES", "YES");
        AnnotationElement.Value storeAttribute = fieldAnnotation.getAttributeValue("store");
        boolean isStored = IndexingMetadata.attributeMatches(storeAttribute, "org.hibernate.search.annotations", "Store.YES", "YES");
        AnnotationElement.Value indexNullAsAttribute = fieldAnnotation.getAttributeValue("indexNullAs");
        String indexNullAs = (String)indexNullAsAttribute.getValue();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            indexNullAs = null;
        }
        if (!(fieldLevelAnalyzerAttribute = (String)(fieldLevelAnalyzerAnnotationAttribute = (AnnotationElement.Annotation)fieldAnnotation.getAttributeValue("analyzer").getValue()).getAttributeValue("definition").getValue()).isEmpty()) {
            fieldLevelAnalyzer = fieldLevelAnalyzerAttribute;
        }
        if (!isAnalyzed && fieldLevelAnalyzer != null) {
            throw new AnnotationParserException("Cannot specify an analyzer for field " + fd.getFullName() + " unless the field is analyzed.");
        }
        String analyzer = Search5MetadataCreator.analyzer(fd.getType(), isAnalyzed, fieldLevelAnalyzer);
        boolean sortable = Search5MetadataCreator.sortable(analyzer, isStored, isSortable);
        FieldMapping fieldMapping = FieldMapping.make(fd, fieldName, isIndexed, isStored, false, sortable).indexNullAs(indexNullAs).analyzer(analyzer).build();
        if (log.isDebugEnabled()) {
            log.debugf("fieldName=%s fieldMapping=%s", fieldName, fieldMapping);
        }
        return fieldMapping;
    }

    private static boolean sortable(String fieldLevelAnalyzer, boolean isStored, boolean isSortable) {
        if (fieldLevelAnalyzer != null) {
            return false;
        }
        return isSortable || isStored;
    }

    private static String analyzer(Type type, boolean analyze, String fieldLevelAnalyzer) {
        if (!Type.STRING.equals((Object)type) || !analyze) {
            return null;
        }
        return fieldLevelAnalyzer != null ? fieldLevelAnalyzer : "standard";
    }

    private static void processLatitude(FieldDescriptor fd, AnnotationElement.Annotation latitudeAnnotation, Map<String, SpatialFieldMapping> spatialFields) {
        String marker = (String)latitudeAnnotation.getAttributeValue("fieldName").getValue();
        if (marker.isEmpty()) {
            marker = null;
        }
        SpatialFieldMapping found = null;
        for (SpatialFieldMapping sf : spatialFields.values()) {
            if (!Objects.equals(sf.marker(), marker)) continue;
            if (found != null) {
                throw new AnnotationParserException("Found multiple latitude fields with the same marketSet value " + marker + " for field " + fd.getFullName());
            }
            found = sf;
        }
        if (found == null) {
            throw new AnnotationParserException("No latitude field found with the marketSet value " + marker + " for field " + fd.getFullName());
        }
        found.setLatitude(fd);
    }

    private static void processLongitude(FieldDescriptor fd, AnnotationElement.Annotation longitudeAnnotation, Map<String, SpatialFieldMapping> spatialFields) {
        String marker = (String)longitudeAnnotation.getAttributeValue("fieldName").getValue();
        if (marker.isEmpty()) {
            marker = null;
        }
        SpatialFieldMapping found = null;
        for (SpatialFieldMapping sf : spatialFields.values()) {
            if (!Objects.equals(sf.marker(), marker)) continue;
            if (found != null) {
                throw new AnnotationParserException("Found multiple longitude fields with the same marketSet value " + marker + " for field " + fd.getFullName());
            }
            found = sf;
        }
        if (found == null) {
            throw new AnnotationParserException("No longitude field found with the marketSet value " + marker + " for field " + fd.getFullName());
        }
        found.setLongitude(fd);
    }
}

