/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.query.impl;

import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.server.core.query.impl.indexing.FieldMapping;
import org.infinispan.server.core.query.impl.indexing.IndexingMetadata;
import org.infinispan.server.core.query.impl.indexing.infinispan.IndexingMetadataHolder;
import org.infinispan.server.core.query.impl.mapping.reference.MessageReferenceProvider;

public final class ProtobufFieldIndexingMetadata
implements IndexedFieldProvider.FieldIndexingMetadata<Descriptor> {
    private final Descriptor messageDescriptor;
    private final String keyProperty;
    private final Descriptor keyMessageDescriptor;

    public ProtobufFieldIndexingMetadata(Descriptor messageDescriptor, Map<String, GenericDescriptor> genericDescriptors) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        this.messageDescriptor = messageDescriptor;
        IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(messageDescriptor, "Indexed");
        if (indexingMetadata != null && indexingMetadata.indexingKey() != null) {
            this.keyProperty = indexingMetadata.indexingKey().fieldName();
            this.keyMessageDescriptor = (Descriptor)genericDescriptors.get(indexingMetadata.indexingKey().typeFullName());
        } else {
            this.keyProperty = null;
            this.keyMessageDescriptor = null;
        }
    }

    public boolean hasProperty(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            FieldMapping fieldMapping;
            ++i;
            FieldDescriptor field = null;
            IndexingMetadata indexingMetadata = (IndexingMetadata)md.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && (fieldMapping = indexingMetadata.getFieldMapping(p)) != null) {
                field = fieldMapping.getFieldDescriptor();
            }
            if (field == null) {
                field = md.findFieldByName(p);
            }
            if (field == null) break;
            if (field.getJavaType() != JavaType.MESSAGE) {
                return i == propertyPath.length;
            }
            md = field.getMessageType();
        }
        return false;
    }

    public boolean isSearchable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldSearchable);
    }

    public boolean isAnalyzed(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldAnalyzed);
    }

    public boolean isNormalized(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldNormalized);
    }

    public boolean isProjectable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldProjectable);
    }

    public boolean isAggregable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldAggregable);
    }

    public boolean isSortable(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldSortable);
    }

    public boolean isVector(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isVectorField);
    }

    public boolean isSpatial(String[] propertyPath) {
        return this.getFlag(propertyPath, IndexingMetadata::isFieldSpatial);
    }

    public Object getNullMarker(String[] propertyPath) {
        Descriptor md = this.messageDescriptor;
        int i = 0;
        for (String p : propertyPath) {
            FieldMapping fieldMapping;
            ++i;
            FieldDescriptor field = null;
            IndexingMetadata indexingMetadata = (IndexingMetadata)md.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && (fieldMapping = indexingMetadata.getFieldMapping(p)) != null) {
                if (i == propertyPath.length) {
                    return fieldMapping.indexNullAs();
                }
                field = fieldMapping.getFieldDescriptor();
            }
            if (field == null) {
                field = md.findFieldByName(p);
            }
            if (i == propertyPath.length || field == null || field.getJavaType() != JavaType.MESSAGE) break;
            md = field.getMessageType();
        }
        return null;
    }

    public Descriptor keyType(String property) {
        return property.equals(this.keyProperty) ? this.keyMessageDescriptor : null;
    }

    private boolean getFlag(String[] propertyPath, BiFunction<IndexingMetadata, String, Boolean> metadataFun) {
        Descriptor md = this.messageDescriptor;
        IndexingMetadataHolder indexingMetadataHolder = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            FieldDescriptor field = md.findFieldByName(property);
            if (field == null) {
                if (i == 0 && (md = this.keyType(property)) != null) continue;
                return false;
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(md, "Indexed");
            if (indexingMetadata == null || !indexingMetadata.isIndexed()) {
                if (indexingMetadataHolder == null || indexingMetadataHolder.getIndexingMetadata() == null) {
                    return false;
                }
                indexingMetadata = indexingMetadataHolder.getIndexingMetadata();
            }
            if (field.getJavaType() == JavaType.MESSAGE && !MessageReferenceProvider.COMMON_MESSAGE_TYPES.contains(field.getTypeName())) {
                FieldMapping embeddedMapping = indexingMetadata.getFieldMapping(property);
                if (embeddedMapping == null || !embeddedMapping.searchable()) {
                    return false;
                }
                md = field.getMessageType();
                indexingMetadataHolder = (IndexingMetadataHolder)IndexingMetadata.findProcessedAnnotation(field, "Embedded");
                continue;
            }
            return metadataFun.apply(indexingMetadata, field.getName());
        }
        return false;
    }
}

